/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.nodes.text.Glyph;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class AWTSVGFont
implements SVGFont {
    @NotNull
    private final Font font;
    private final float stretch;
    private final FontRenderContext frc = new FontRenderContext(null, true, true);
    private final HashMap<Character, Glyph> glyphCache;

    public AWTSVGFont(@NotNull Font font, float stretch) {
        this.font = font;
        this.stretch = stretch;
        this.glyphCache = new HashMap();
    }

    @NotNull
    public Font font() {
        return this.font;
    }

    @Override
    @NotNull
    public Glyph codepointGlyph(char codepoint) {
        Glyph glyph = this.glyphCache.get(Character.valueOf(codepoint));
        if (glyph != null) {
            return glyph;
        }
        glyph = this.createGlyph(codepoint);
        this.glyphCache.put(Character.valueOf(codepoint), glyph);
        return glyph;
    }

    @NotNull
    private Glyph createGlyph(char codepoint) {
        char[] buffer = new char[]{codepoint};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, buffer);
        GlyphMetrics gm = glyphVector.getGlyphMetrics(0);
        float advance = gm.getAdvanceX();
        Shape shape = glyphVector.getGlyphOutline(0);
        return new Glyph(codepoint, shape, advance, gm.getBounds2D().isEmpty());
    }
}

