/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.AWTSVGFont;
import com.github.weisj.jsvg.attributes.font.FontStyle;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class FontResolver {
    private FontResolver() {
    }

    @NotNull
    public static SVGFont resolve(@NotNull MeasurableFontSpec fontSpec, @NotNull MeasureContext measureContext) {
        FontCache.CacheKey key = new FontCache.CacheKey(fontSpec, measureContext);
        SVGFont cachedFont = (SVGFont)FontCache.cache.get(key);
        if (cachedFont != null) {
            return cachedFont;
        }
        String[] families = fontSpec.families();
        FontStyle style = fontSpec.style();
        int normalWeight = 400;
        float currentWeight = fontSpec.currentWeight();
        if (currentWeight > (float)normalWeight) {
            float awtWeightCompensationFactor = TextAttribute.WEIGHT_BOLD.floatValue() * (float)normalWeight / 700.0f;
            currentWeight *= awtWeightCompensationFactor;
        }
        float weight = currentWeight / (float)normalWeight;
        float size = fontSpec.effectiveSize(measureContext);
        float stretch = fontSpec.stretch();
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>(4, 1.0f);
        attributes.put(TextAttribute.FAMILY, families[0]);
        attributes.put(TextAttribute.SIZE, Float.valueOf(size));
        attributes.put(TextAttribute.WEIGHT, Float.valueOf(weight));
        if (style instanceof FontStyle.Normal) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        } else if (style instanceof FontStyle.Italic) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            AffineTransform transform = style.transform();
            if (transform != null) {
                attributes.put(TextAttribute.TRANSFORM, transform);
            }
        }
        Font font = new Font(attributes);
        AWTSVGFont resolvedFont = new AWTSVGFont(font, stretch);
        FontCache.cache.put(key, resolvedFont);
        return resolvedFont;
    }

    private static final class FontCache {
        private static final HashMap<CacheKey, SVGFont> cache = new HashMap();

        private FontCache() {
        }

        private static final class CacheKey {
            @NotNull
            private final MeasurableFontSpec spec;
            @NotNull
            private final MeasureContext context;

            private CacheKey(@NotNull MeasurableFontSpec spec, @NotNull MeasureContext context) {
                this.spec = spec;
                this.context = context;
            }

            public String toString() {
                return "CacheKey{spec=" + this.spec + ", context=" + this.context + '}';
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return this.spec.equals(cacheKey.spec) && this.context.equals(cacheKey.context);
            }

            public int hashCode() {
                return Objects.hash(this.spec, this.context);
            }
        }
    }
}

