/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.stroke;

import com.github.weisj.jsvg.attributes.stroke.LineCap;
import com.github.weisj.jsvg.attributes.stroke.LineJoin;
import com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.annotations.NotNull;

public final class StrokeParser {
    public static final LineCap DEFAULT_LINECAP = LineCap.Butt;
    public static final LineJoin DEFAULT_LINEJOIN = LineJoin.Miter;
    public static final float DEFAULT_MITER_LIMIT = 4.0f;

    private StrokeParser() {
    }

    @NotNull
    public static LineCap parseLineCap(@NotNull AttributeNode node) {
        return node.getEnum("stroke-linecap", DEFAULT_LINECAP);
    }

    @NotNull
    public static LineJoin parseLineJoin(@NotNull AttributeNode node) {
        return node.getEnum("stroke-linejoin", LineJoin.Miter);
    }

    public static float parseMiterLimit(@NotNull AttributeNode node) {
        return node.getFloat("stroke-miterlimit", 4.0f);
    }
}

