/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.SVGEllipse;
import com.github.weisj.jsvg.geometry.SVGLine;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class AWTSVGShape<T extends Shape>
implements MeasurableShape {
    public static final Rectangle2D EMPTY_SHAPE = new Rectangle();
    public static final SVGShape EMPTY = new AWTSVGShape<Rectangle2D>(EMPTY_SHAPE, 0.0);
    @NotNull
    protected final T shape;
    private Rectangle2D bounds;
    private double pathLength;

    public AWTSVGShape(@NotNull T shape) {
        this(shape, Double.NaN);
    }

    private AWTSVGShape(@NotNull T shape, double pathLength) {
        this.shape = shape;
        this.pathLength = pathLength;
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        return this.shape;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (this.bounds == null) {
            this.bounds = this.shape.getBounds2D();
        }
        return this.bounds;
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        if (Double.isNaN(this.pathLength)) {
            this.pathLength = this.computePathLength();
        }
        return this.pathLength;
    }

    private double computePathLength() {
        if (this.shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)this.shape;
            return 2.0 * (r.getWidth() + r.getHeight());
        }
        if (this.shape instanceof Ellipse2D) {
            double h;
            Ellipse2D e = (Ellipse2D)this.shape;
            double w = e.getWidth();
            if (w == (h = e.getHeight())) {
                return Math.PI * w;
            }
            return SVGEllipse.ellipseCircumference(w / 2.0, h / 2.0);
        }
        return this.computeGenericPathLength();
    }

    private double computeGenericPathLength() {
        PathIterator pathIterator = this.shape.getPathIterator(null);
        double length = 0.0;
        double x = 0.0;
        double y = 0.0;
        double xStart = x;
        double yStart = y;
        double[] args = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(args)) {
                case 0: {
                    x = args[0];
                    y = args[1];
                    xStart = x;
                    yStart = y;
                    break;
                }
                case 1: {
                    length += this.lineLength(x, y, args[0], args[1]);
                    x = args[0];
                    y = args[1];
                    break;
                }
                case 2: {
                    length += this.quadraticParametricLength(x, y, args[0], args[1], args[2], args[3]);
                    x = args[2];
                    y = args[3];
                    break;
                }
                case 3: {
                    length += this.cubicParametricLength(x, y, args[0], args[1], args[2], args[3], args[4], args[5]);
                    x = args[4];
                    y = args[5];
                    break;
                }
                case 4: {
                    length += this.lineLength(x, y, args[0], args[1]);
                    x = xStart;
                    y = yStart;
                }
            }
            pathIterator.next();
        }
        return length;
    }

    private double lineLength(double x1, double y1, double x2, double y2) {
        return SVGLine.lineLength(x1, y1, x2, y2);
    }

    private double quadraticParametricLength(double ax, double ay, double bx, double by, double cx, double cy) {
        if (ax == cx && ay == cy) {
            if (ax == bx && ay == by) {
                return 0.0;
            }
            return this.lineLength(ax, ay, bx, by);
        }
        if (ax == bx && ay == by || cx == bx && cy == by) {
            return this.lineLength(ax, ay, cx, cy);
        }
        double ax0 = bx - ax;
        double ay0 = by - ay;
        double ax1 = ax - 2.0 * bx + cx;
        double ay1 = ay - 2.0 * by + cy;
        if (ax1 != 0.0 || ay1 != 0.0) {
            double c = 4.0 * this.dot2D(ax1, ay1, ax1, ay1);
            double b = 8.0 * this.dot2D(ax0, ay0, ax1, ay1);
            double a = 8.0 * this.dot2D(ax0, ay0, ax0, ay0);
            double q = 4.0 * a * c - b * b;
            double twoCpB = 2.0 * c + b;
            double sumCBA = c + b + a;
            double l0 = 0.25 / c * (twoCpB * Math.sqrt(sumCBA) - b * Math.sqrt(a));
            if (q == 0.0) {
                return l0;
            }
            double l1 = q / (8.0 * Math.pow(c, 1.5)) * (Math.log(2.0 * Math.sqrt(c * sumCBA) + twoCpB) - Math.log(2.0 * Math.sqrt(c * a) + b));
            return l0 + l1;
        }
        return 2.0 * this.lineLength(0.0, 0.0, ax0, ay0);
    }

    private double dot2D(double x1, double y1, double x2, double y2) {
        return x1 * x2 * y1 * y2;
    }

    private double cubicParametricLength(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        double qx = (3.0 * cx - dx + 3.0 * bx - ax) / 4.0;
        double qy = (3.0 * cy - dy + 3.0 * by - ay) / 4.0;
        return this.quadraticParametricLength(ax, ay, qx, qy, dx, dy);
    }
}

