/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class Cubic
extends PathCommand {
    private final float k1x;
    private final float k1y;
    private final float k2x;
    private final float k2y;
    private final float x;
    private final float y;

    public Cubic(boolean isRelative, float k1x, float k1y, float k2x, float k2y, float x, float y) {
        super(isRelative);
        this.k1x = k1x;
        this.k1y = k1y;
        this.k2x = k2x;
        this.k2y = k2y;
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        path.curveTo(this.k1x + xOff, this.k1y + yOff, this.k2x + xOff, this.k2y + yOff, this.x + xOff, this.y + yOff);
        hist.setLastPoint(this.x + xOff, this.y + yOff);
        hist.setLastKnot(this.k2x + xOff, this.k2y + yOff);
    }

    @Override
    public int getInnerNodes() {
        return 6;
    }

    public String toString() {
        return "C " + this.k1x + " " + this.k1y + " " + this.k2x + " " + this.k2y + " " + this.x + " " + this.y;
    }
}

