/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class CubicSmooth
extends PathCommand {
    private final float x;
    private final float y;
    private final float k2x;
    private final float k2y;

    public CubicSmooth(boolean isRelative, float k2x, float k2y, float x, float y) {
        super(isRelative);
        this.k2x = k2x;
        this.k2y = k2y;
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        float oldKx = hist.lastKnot.x;
        float oldKy = hist.lastKnot.y;
        float oldX = hist.lastPoint.x;
        float oldY = hist.lastPoint.y;
        float k1x = oldX * 2.0f - oldKx;
        float k1y = oldY * 2.0f - oldKy;
        path.curveTo(k1x, k1y, this.k2x + xOff, this.k2y + yOff, this.x + xOff, this.y + yOff);
        hist.setLastPoint(this.x + xOff, this.y + yOff);
        hist.setLastKnot(this.k2x + xOff, this.k2y + yOff);
    }

    @Override
    public int getInnerNodes() {
        return 6;
    }

    public String toString() {
        return "S " + this.k2x + " " + this.k2y + " " + this.x + " " + this.y;
    }
}

