/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class Horizontal
extends PathCommand {
    private final float x;

    public Horizontal(boolean isRelative, float x) {
        super(isRelative);
        this.x = x;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = hist.lastPoint.y;
        path.lineTo(this.x + xOff, yOff);
        hist.setLastPoint(this.x + xOff, yOff);
        hist.setLastKnot(this.x + xOff, yOff);
    }

    @Override
    public int getInnerNodes() {
        return 2;
    }

    public String toString() {
        return "H " + this.x;
    }
}

