/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class LineTo
extends PathCommand {
    private final float x;
    private final float y;

    public LineTo(boolean isRelative, float x, float y) {
        super(isRelative);
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        path.lineTo(this.x + xOff, this.y + yOff);
        hist.setLastPoint(this.x + xOff, this.y + yOff);
        hist.setLastKnot(this.x + xOff, this.y + yOff);
    }

    @Override
    public int getInnerNodes() {
        return 2;
    }

    public String toString() {
        return "L " + this.x + " " + this.y;
    }
}

