/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class Quadratic
extends PathCommand {
    private final float kx;
    private final float ky;
    private final float x;
    private final float y;

    public String toString() {
        return "Q " + this.kx + " " + this.ky + " " + this.x + " " + this.y;
    }

    public Quadratic(boolean isRelative, float kx, float ky, float x, float y) {
        super(isRelative);
        this.kx = kx;
        this.ky = ky;
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        path.quadTo(this.kx + xOff, this.ky + yOff, this.x + xOff, this.y + yOff);
        hist.setLastPoint(this.x + xOff, this.y + yOff);
        hist.setLastKnot(this.kx + xOff, this.ky + yOff);
    }

    @Override
    public int getInnerNodes() {
        return 4;
    }
}

