/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class QuadraticSmooth
extends PathCommand {
    private final float x;
    private final float y;

    public QuadraticSmooth(boolean isRelative, float x, float y) {
        super(isRelative);
        this.x = x;
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = this.isRelative ? hist.lastPoint.x : 0.0f;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        float oldKx = hist.lastKnot.x;
        float oldKy = hist.lastKnot.y;
        float oldX = hist.lastPoint.x;
        float oldY = hist.lastPoint.y;
        float kx = oldX * 2.0f - oldKx;
        float ky = oldY * 2.0f - oldKy;
        path.quadTo(kx, ky, this.x + xOff, this.y + yOff);
        hist.setLastPoint(this.x + xOff, this.y + yOff);
        hist.setLastKnot(kx, ky);
    }

    @Override
    public int getInnerNodes() {
        return 4;
    }

    public String toString() {
        return "T " + this.x + " " + this.y;
    }
}

