/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

class Vertical
extends PathCommand {
    private final float y;

    public Vertical(boolean isRelative, float y) {
        super(isRelative);
        this.y = y;
    }

    @Override
    public void appendPath(@NotNull Path2D path, @NotNull BuildHistory hist) {
        float xOff = hist.lastPoint.x;
        float yOff = this.isRelative ? hist.lastPoint.y : 0.0f;
        path.lineTo(xOff, this.y + yOff);
        hist.setLastPoint(xOff, this.y + yOff);
        hist.setLastKnot(xOff, this.y + yOff);
    }

    @Override
    public int getInnerNodes() {
        return 2;
    }

    public String toString() {
        return "V " + this.y;
    }
}

