/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.size;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public enum AngleUnit {
    Deg,
    Grad,
    Rad,
    Turn,
    Raw("");

    static AngleUnit[] units;
    private static final double GRADIANS_TO_RADIANS = 0.015707962916848627;
    @NotNull
    private final String suffix;

    public static AngleUnit[] units() {
        return units;
    }

    private AngleUnit(String suffix) {
        this.suffix = suffix;
    }

    private AngleUnit() {
        this.suffix = this.name().toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public String suffix() {
        return this.suffix;
    }

    public float toRadians(float value, @NotNull AngleUnit rawReplacement) {
        if (rawReplacement == Raw) {
            throw new IllegalArgumentException("Cant replace raw unit with raw");
        }
        switch (this) {
            case Deg: {
                return (float)Math.toRadians(value);
            }
            case Grad: {
                return (float)((double)value * 0.015707962916848627);
            }
            case Rad: {
                return value;
            }
            case Turn: {
                return (float)((double)value * Math.PI * 2.0);
            }
            case Raw: {
                return rawReplacement.toRadians(value, rawReplacement);
            }
        }
        throw new IllegalArgumentException("Unknown angle unit " + (Object)((Object)this));
    }

    static {
        units = AngleUnit.values();
    }
}

