/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.AbstractSVGNode;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.HasClip;
import com.github.weisj.jsvg.nodes.prototype.HasFilter;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.nodes.prototype.Transformable;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderableSVGNode
extends AbstractSVGNode
implements Renderable,
Transformable,
HasClip,
HasFilter {
    private boolean isVisible;
    @Nullable
    private AffineTransform transform;
    private Length transformOriginX;
    private Length transformOriginY;
    @Nullable
    private ClipPath clipPath;
    @Nullable
    private Mask mask;
    @Nullable
    private Filter filter;

    @Override
    @Nullable
    public ClipPath clipPath() {
        return this.clipPath;
    }

    @Override
    @Nullable
    public Mask mask() {
        return this.mask;
    }

    @Override
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    @Override
    public boolean isVisible(@NotNull RenderContext context) {
        return this.isVisible && context.rawOpacity() > 0.0f;
    }

    @Override
    @Nullable
    public AffineTransform transform() {
        return this.transform;
    }

    @Override
    @NotNull
    public Point2D transformOrigin(@NotNull MeasureContext context) {
        return new Point2D.Float(this.transformOriginX.resolveWidth(context), this.transformOriginY.resolveHeight(context));
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isVisible = this.parseIsVisible(attributeNode);
        this.clipPath = attributeNode.getClipPath();
        this.mask = attributeNode.getMask();
        this.filter = attributeNode.getFilter();
        this.transform = attributeNode.parseTransform("transform");
        Length[] transformOrigin = attributeNode.getLengthList("transform-origin");
        this.transformOriginX = transformOrigin.length > 0 ? transformOrigin[0] : Length.ZERO;
        this.transformOriginY = transformOrigin.length > 1 ? transformOrigin[1] : Length.ZERO;
    }
}

