/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.container;

import com.github.weisj.jsvg.attributes.PreserveAspectRatio;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.container.RenderableContainerNode;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInnerViewContainer
extends RenderableContainerNode {
    protected ViewBox viewBox;
    protected PreserveAspectRatio preserveAspectRatio;

    @NotNull
    protected abstract Point2D outerLocation(@NotNull MeasureContext var1);

    @Nullable
    protected abstract Point2D anchorLocation(@NotNull MeasureContext var1);

    @NotNull
    public abstract FloatSize size(@NotNull RenderContext var1);

    @Nullable
    public ViewBox viewBox() {
        return this.viewBox;
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.viewBox = attributeNode.getViewBox();
        this.preserveAspectRatio = PreserveAspectRatio.parse(attributeNode.getValue("preserveAspectRatio"), attributeNode.parser());
    }

    @Override
    public final void render(@NotNull RenderContext context, @NotNull Graphics2D g) {
        this.renderWithSize(this.size(context), this.viewBox(), null, context, g);
    }

    @NotNull
    protected RenderContext createInnerContext(@NotNull RenderContext context, @NotNull ViewBox viewBox) {
        return NodeRenderer.setupInnerViewRenderContext(viewBox, context, true);
    }

    public final void renderWithSize(@NotNull FloatSize useSiteSize, @Nullable ViewBox view, @NotNull RenderContext context, @NotNull Graphics2D g) {
        this.renderWithSize(useSiteSize, view, null, context, g);
    }

    public final void renderWithSize(@NotNull FloatSize useSiteSize, @Nullable ViewBox view, @Nullable PreserveAspectRatio preserveAspectRatio, @NotNull RenderContext context, @NotNull Graphics2D g) {
        MeasureContext measureContext = context.measureContext();
        Point2D outerPos = this.outerLocation(measureContext);
        if (Length.isUnspecified(useSiteSize.width) || Length.isUnspecified(useSiteSize.height)) {
            FloatSize size = this.size(context);
            if (Length.isUnspecified(useSiteSize.width)) {
                useSiteSize.width = size.width;
            }
            if (Length.isUnspecified(useSiteSize.height)) {
                useSiteSize.height = size.height;
            }
        }
        if (preserveAspectRatio == null) {
            preserveAspectRatio = this.preserveAspectRatio;
        }
        g.translate(outerPos.getX(), outerPos.getY());
        AffineTransform viewTransform = view != null ? preserveAspectRatio.computeViewPortTransform(useSiteSize, view) : null;
        FloatSize viewSize = view != null ? view.size() : useSiteSize;
        RenderContext innerContext = this.createInnerContext(context, new ViewBox(viewSize));
        MeasureContext innerMeasure = innerContext.measureContext();
        Point2D anchorPos = this.anchorLocation(innerMeasure);
        if (anchorPos != null) {
            if (viewTransform != null) {
                anchorPos.setLocation(anchorPos.getX() * viewTransform.getScaleX() - viewTransform.getTranslateX(), anchorPos.getY() * viewTransform.getScaleY() - viewTransform.getTranslateY());
            }
            g.translate(anchorPos.getX(), anchorPos.getY());
        }
        g.clip(new ViewBox(useSiteSize));
        if (viewTransform != null) {
            g.transform(viewTransform);
        }
        super.render(innerContext, g);
    }
}

