/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.container;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import com.github.weisj.jsvg.attributes.font.FontParser;
import com.github.weisj.jsvg.nodes.container.BaseContainerNode;
import com.github.weisj.jsvg.nodes.prototype.HasContext;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.PaintContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRenderableContainerNode<E>
extends BaseContainerNode<E>
implements Renderable,
HasContext {
    private boolean isVisible;
    private PaintContext paintContext;
    private FontRenderContext fontRenderContext;
    private AttributeFontSpec fontSpec;
    private FillRule fillRule;

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isVisible = this.parseIsVisible(attributeNode);
        this.paintContext = PaintContext.parse(attributeNode);
        this.fontRenderContext = FontRenderContext.parse(attributeNode);
        this.fontSpec = FontParser.parseFontSpec(attributeNode);
        this.fillRule = this.parseFillRule(attributeNode);
    }

    @Override
    public boolean isVisible(@NotNull RenderContext context) {
        return this.isVisible;
    }

    @NotNull
    public final PaintContext paintContext() {
        return this.paintContext;
    }

    @Override
    @NotNull
    public final FontRenderContext fontRenderContext() {
        return this.fontRenderContext;
    }

    @NotNull
    public final AttributeFontSpec fontSpec() {
        return this.fontSpec;
    }

    @Override
    @NotNull
    public final FillRule fillRule() {
        return this.fillRule;
    }
}

