/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.AbstractSVGNode;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

public abstract class FilterPrimitive
extends AbstractSVGNode {
    Length x;
    Length y;
    Length width;
    Length height;
    private Object inputChannel;
    private Object resultChannel;

    @NotNull
    protected Channel inputChannel(@NotNull FilterContext context) {
        Channel input = context.getChannel(this.inputChannel);
        if (input == null) {
            throw new IllegalStateException("Input channel [" + this.inputChannel + "] doesn't exist.");
        }
        return input;
    }

    protected void saveResult(@NotNull Channel output, @NotNull FilterContext filterContext) {
        filterContext.addResult(this.resultChannel, output);
        if (this.resultChannel != DefaultFilterChannel.LastResult) {
            filterContext.addResult(DefaultFilterChannel.LastResult, output);
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.x = attributeNode.getLength("x", Unit.PERCENTAGE.valueOf(0.0f));
        this.y = attributeNode.getLength("y", Unit.PERCENTAGE.valueOf(0.0f));
        this.width = attributeNode.getLength("width", Unit.PERCENTAGE.valueOf(100.0f));
        this.height = attributeNode.getLength("height", Unit.PERCENTAGE.valueOf(100.0f));
        this.inputChannel = attributeNode.getValue("in");
        if (this.inputChannel == null) {
            this.inputChannel = DefaultFilterChannel.LastResult;
        }
        this.resultChannel = attributeNode.getValue("result");
        if (this.resultChannel == null) {
            this.resultChannel = DefaultFilterChannel.LastResult;
        }
    }

    public abstract void applyFilter(@NotNull Graphics2D var1, @NotNull RenderContext var2, @NotNull FilterContext var3);
}

