/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.ShapeRenderer;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

final class GlyphRenderer {
    private static final boolean DEBUG = false;

    private GlyphRenderer() {
    }

    static void prepareGlyphRun(@NotNull StringTextSegment segment, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull RenderContext context) {
        MeasureContext measure = context.measureContext();
        Shape glyphRun = GlyphRenderer.layoutGlyphRun(segment, cursor, font, measure, context.fontRenderContext());
        Rectangle2D bounds = glyphRun.getBounds2D();
        if (Length.isUnspecified((float)cursor.completeGlyphRunBounds.getX())) {
            cursor.completeGlyphRunBounds.setRect(bounds);
        } else {
            Rectangle2D.union(cursor.completeGlyphRunBounds, bounds, cursor.completeGlyphRunBounds);
        }
        segment.currentGlyphRun = glyphRun;
        segment.currentRenderContext = context;
    }

    static void renderGlyphRun(@NotNull StringTextSegment segment, @NotNull Rectangle2D completeGlyphRunBounds, @NotNull Graphics2D g) {
        RenderContext context = segment.currentRenderContext;
        assert (context != null);
        Shape glyphRun = segment.currentGlyphRun;
        assert (glyphRun != null);
        Stroke stroke = context.stroke(1.0f);
        ShapeRenderer.renderShape(context, g, glyphRun, completeGlyphRunBounds, stroke, true, true);
        segment.currentRenderContext = null;
        segment.currentGlyphRun = null;
    }

    static Shape layoutGlyphRun(@NotNull StringTextSegment segment, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull MeasureContext measure, @NotNull FontRenderContext fontRenderContext) {
        Glyph glyph;
        char codepoint;
        AffineTransform glyphTransform;
        float letterSpacing = fontRenderContext.letterSpacing().resolveLength(measure);
        Path2D.Float glyphPath = new Path2D.Float();
        char[] cArray = segment.codepoints();
        int n = cArray.length;
        for (int i = 0; i < n && (glyphTransform = cursor.advance(codepoint = cArray[i], measure, glyph = font.codepointGlyph(codepoint), letterSpacing)) != null; ++i) {
            if (!glyph.isRendered()) continue;
            Shape glyphOutline = glyph.glyphOutline();
            Shape renderPath = glyphTransform.createTransformedShape(glyphOutline);
            glyphPath.append(renderPath, false);
        }
        return glyphPath;
    }
}

