/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PathGlyphCursor
extends GlyphCursor {
    private static final float EPS = 1.0E-4f;
    private float xStart;
    private float yStart;
    private float segmentLength;
    private final float[] cords;
    @NotNull
    private final PathIterator pathIterator;

    PathGlyphCursor(@NotNull PathIterator pathIterator, float startOffset) {
        super(0.0f, 0.0f, new AffineTransform());
        this.pathIterator = pathIterator;
        this.cords = new float[2];
        this.setupIterator(pathIterator);
        this.advance(startOffset);
    }

    PathGlyphCursor(@NotNull GlyphCursor cursor, float startOffset, @NotNull PathIterator pathIterator) {
        super(cursor);
        this.pathIterator = pathIterator;
        this.cords = new float[2];
        this.setupIterator(pathIterator);
        this.advance(startOffset);
    }

    private PathGlyphCursor(@NotNull PathGlyphCursor pathCursor) {
        super(pathCursor);
        this.pathIterator = pathCursor.pathIterator;
        this.xStart = pathCursor.xStart;
        this.yStart = pathCursor.yStart;
        this.segmentLength = pathCursor.segmentLength;
        this.cords = pathCursor.cords;
    }

    @Override
    GlyphCursor derive() {
        return new PathGlyphCursor(this);
    }

    @Override
    void updateFrom(GlyphCursor local) {
        super.updateFrom(local);
        assert (local instanceof PathGlyphCursor);
        PathGlyphCursor glyphCursor = (PathGlyphCursor)local;
        this.xStart = glyphCursor.xStart;
        this.yStart = glyphCursor.yStart;
        this.segmentLength = glyphCursor.segmentLength;
    }

    private void setupIterator(@NotNull PathIterator pathIterator) {
        if (!pathIterator.isDone()) {
            if (pathIterator.currentSegment(this.cords) != 0) {
                throw new IllegalStateException("Path iterator didn't establish starting position");
            }
            this.xStart = this.cords[0];
            this.yStart = this.cords[1];
            this.x = this.xStart;
            this.y = this.yStart;
        } else {
            this.xStart = this.x;
            this.yStart = this.y;
        }
    }

    @Override
    @Nullable
    AffineTransform advance(char c, @NotNull MeasureContext measure, @NotNull Glyph glyph, float letterSpacing) {
        if (this.pathIterator.isDone() && this.segmentLength < 1.0E-4f) {
            return null;
        }
        float deltaX = this.nextDeltaX(measure);
        if (deltaX != 0.0f) {
            this.advance(deltaX);
        }
        float curX = this.x;
        float curY = this.y;
        float advanceDist = glyph.advance();
        if (this.segmentLength > advanceDist / 2.0f) {
            this.advance(advanceDist);
        } else {
            this.advance(advanceDist / 2.0f);
            if (this.pathIterator.isDone() && this.segmentLength < 1.0E-4f) {
                return null;
            }
            this.advance(advanceDist / 2.0f);
        }
        this.transform.setToTranslation(curX, curY);
        float charRotation = this.calculateSegmentRotation(curX, curY, this.x, this.y);
        this.transform.rotate(charRotation, 0.0, 0.0);
        float deltaY = this.nextDeltaY(measure);
        if (deltaY != 0.0f) {
            float nx = -(this.y - curY);
            float ny = this.x - curX;
            float nn = deltaY / this.norm(nx, ny);
            this.transform.translate(nx * nn, ny * nn);
        }
        this.advance(letterSpacing);
        return this.transform;
    }

    private void advance(float distance) {
        this.advanceInsideSegment(this.advanceIntoSegment(distance));
    }

    private float advanceIntoSegment(float distance) {
        if (distance < 1.0E-4f) {
            return 0.0f;
        }
        while (!this.pathIterator.isDone() && this.segmentLength < distance) {
            distance -= this.segmentLength;
            this.iterateToNextSegment();
            this.segmentLength = this.calculateSegmentLength();
        }
        return distance;
    }

    private void advanceInsideSegment(float distance) {
        if (distance < 1.0E-4f) {
            return;
        }
        float xStep = this.cords[0] - this.x;
        float yStep = this.cords[1] - this.y;
        float fraction = distance / this.segmentLength;
        this.x += xStep * fraction;
        this.y += yStep * fraction;
        this.segmentLength -= distance;
    }

    private void iterateToNextSegment() {
        assert (!this.pathIterator.isDone());
        do {
            this.x = this.cords[0];
            this.y = this.cords[1];
            switch (this.pathIterator.currentSegment(this.cords)) {
                case 4: {
                    this.cords[0] = this.xStart;
                    this.cords[1] = this.yStart;
                    return;
                }
                case 1: {
                    this.pathIterator.next();
                    return;
                }
                case 0: {
                    this.xStart = this.x;
                    this.yStart = this.y;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.pathIterator.next();
        } while (!this.pathIterator.isDone());
    }

    private float calculateSegmentRotation(float x1, float y1, float x2, float y2) {
        return (float)Math.atan2(y2 - y1, x2 - x1);
    }

    private float calculateSegmentLength() {
        return this.norm(this.cords[0] - this.x, this.cords[1] - this.y);
    }

    private float norm(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }
}

