/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import com.github.weisj.jsvg.attributes.font.FontParser;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.attributes.text.LengthAdjust;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.container.BaseRenderableContainerNode;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.GlyphRenderer;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.nodes.text.TextSegment;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TextContainer
extends BaseRenderableContainerNode<TextSegment>
implements TextSegment.RenderableSegment,
HasShape {
    private final List<TextSegment> segments = new ArrayList<TextSegment>();
    protected AttributeFontSpec fontSpec;
    protected LengthAdjust lengthAdjust;
    protected Length textLength;

    TextContainer() {
    }

    @NotNull
    protected List<TextSegment> segments() {
        return this.segments;
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.fontSpec = FontParser.parseFontSpec(attributeNode);
        this.lengthAdjust = attributeNode.getEnum("lengthAdjust", LengthAdjust.Spacing);
        this.textLength = attributeNode.getLength("textLength", Length.UNSPECIFIED);
    }

    @Override
    protected boolean acceptChild(@Nullable String id, @NotNull SVGNode node) {
        return node instanceof TextSegment;
    }

    @Override
    protected void doAdd(@NotNull SVGNode node) {
        this.segments.add((TextSegment)((Object)node));
    }

    @Override
    public final void addContent(char[] content) {
        if (content.length == 0) {
            return;
        }
        this.segments.add(new StringTextSegment(content));
    }

    @Override
    public List<? extends @NotNull TextSegment> children() {
        return this.segments;
    }

    protected abstract GlyphCursor createLocalCursor(@NotNull RenderContext var1, @NotNull GlyphCursor var2);

    protected abstract void cleanUpLocalCursor(@NotNull GlyphCursor var1, @NotNull GlyphCursor var2);

    protected final void renderSegment(@NotNull GlyphCursor cursor, @NotNull RenderContext context, @NotNull Graphics2D g) {
        double offset;
        this.prepareSegmentForRendering(cursor, context);
        switch (context.fontRenderContext().textAnchor()) {
            default: {
                offset = 0.0;
                break;
            }
            case Middle: {
                offset = cursor.completeGlyphRunBounds.getWidth() / 2.0;
                break;
            }
            case End: {
                offset = cursor.completeGlyphRunBounds.getWidth();
            }
        }
        g.translate(-offset, 0.0);
        this.renderSegmentWithoutLayout(cursor, context, g);
    }

    @Override
    public void renderSegmentWithoutLayout(@NotNull GlyphCursor cursor, @NotNull RenderContext context, @NotNull Graphics2D g) {
        for (TextSegment textSegment : this.children()) {
            RenderContext currentContext = context;
            if (textSegment instanceof Renderable) {
                if (!((Renderable)((Object)textSegment)).isVisible(context)) continue;
                currentContext = NodeRenderer.setupRenderContext(textSegment, context);
            }
            if (textSegment instanceof StringTextSegment) {
                GlyphRenderer.renderGlyphRun((StringTextSegment)textSegment, cursor.completeGlyphRunBounds, g);
                continue;
            }
            if (textSegment instanceof TextSegment.RenderableSegment) {
                ((TextSegment.RenderableSegment)textSegment).renderSegmentWithoutLayout(cursor, currentContext, g);
                continue;
            }
            throw new IllegalStateException("Can't render segment " + textSegment);
        }
    }

    @Override
    public void prepareSegmentForRendering(@NotNull GlyphCursor cursor, @NotNull RenderContext context) {
        SVGFont font = context.font();
        GlyphCursor localCursor = this.createLocalCursor(context, cursor);
        for (TextSegment textSegment : this.children()) {
            RenderContext currentContext = context;
            if (textSegment instanceof Renderable) {
                if (!((Renderable)((Object)textSegment)).isVisible(context)) continue;
                currentContext = NodeRenderer.setupRenderContext(textSegment, context);
            }
            if (textSegment instanceof StringTextSegment) {
                GlyphRenderer.prepareGlyphRun((StringTextSegment)textSegment, localCursor, font, currentContext);
                continue;
            }
            if (textSegment instanceof TextSegment.RenderableSegment) {
                ((TextSegment.RenderableSegment)textSegment).prepareSegmentForRendering(localCursor, currentContext);
                continue;
            }
            throw new IllegalStateException("Can't render segment " + textSegment);
        }
        this.cleanUpLocalCursor(cursor, localCursor);
    }

    @Override
    public void appendTextShape(@NotNull GlyphCursor cursor, @NotNull Path2D textShape, @NotNull RenderContext context) {
        SVGFont font = context.font();
        GlyphCursor localCursor = this.createLocalCursor(context, cursor);
        for (TextSegment textSegment : this.children()) {
            RenderContext currentContext = context;
            if (textSegment instanceof Renderable) {
                if (!((Renderable)((Object)textSegment)).isVisible(context)) continue;
                currentContext = NodeRenderer.setupRenderContext(textSegment, context);
            }
            if (textSegment instanceof StringTextSegment) {
                Shape glyphRun = GlyphRenderer.layoutGlyphRun((StringTextSegment)textSegment, localCursor, font, currentContext.measureContext(), currentContext.fontRenderContext());
                textShape.append(glyphRun, false);
                continue;
            }
            if (textSegment instanceof TextSegment.RenderableSegment) {
                ((TextSegment.RenderableSegment)textSegment).appendTextShape(localCursor, textShape, currentContext);
                continue;
            }
            throw new IllegalStateException("Can't compute shape of segment " + textSegment);
        }
        this.cleanUpLocalCursor(cursor, localCursor);
    }

    @Override
    @NotNull
    public Rectangle2D untransformedElementBounds(@NotNull RenderContext context) {
        return this.untransformedElementShape(context).getBounds2D();
    }
}

