/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeNode {
    private static final Length TopOrLeft = new Length(Unit.PERCENTAGE, 0.0f);
    private static final Length Center = new Length(Unit.PERCENTAGE, 50.0f);
    private static final Length BottomOrRight = new Length(Unit.PERCENTAGE, 100.0f);
    @NotNull
    private final String tagName;
    @NotNull
    private final Map<String, String> attributes;
    @Nullable
    private final AttributeNode parent;
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull Object> namedElements;
    @NotNull
    private final AttributeParser attributeParser;

    public AttributeNode(@NotNull String tagName, @NotNull Map<String, String> attributes, @Nullable AttributeNode parent, @NotNull @NotNull Map<@NotNull String, @NotNull Object> namedElements, @NotNull AttributeParser attributeParser) {
        this.tagName = tagName;
        this.attributes = AttributeNode.preprocessAttributes(attributes);
        this.parent = parent;
        this.namedElements = namedElements;
        this.attributeParser = attributeParser;
    }

    @NotNull
    Map<String, Object> namedElements() {
        return this.namedElements;
    }

    @NotNull
    private static Map<String, String> preprocessAttributes(@NotNull Map<String, String> attributes) {
        String styleStr = attributes.get("style");
        if (styleStr != null) {
            String[] styles;
            for (String style : styles = styleStr.split(";")) {
                String[] styleDef = style.split(":", 2);
                attributes.put(styleDef[0].trim().toLowerCase(Locale.ENGLISH), styleDef[1].trim());
            }
        }
        return attributes;
    }

    @Nullable
    private <T> T getElementById(@NotNull Class<T> type, @Nullable String id) {
        if (id == null) {
            return null;
        }
        Object node = this.namedElements.get(id);
        return type.isInstance(node) ? (T)type.cast(node) : null;
    }

    @Nullable
    private <T> T getElementByUrl(@NotNull Class<T> type, @Nullable String value) {
        String url = this.attributeParser.parseUrl(value);
        if (url != null && url.startsWith("#")) {
            url = url.substring(1);
        }
        return this.getElementById(type, url);
    }

    @Nullable
    public <T> T getElementByHref(@NotNull Class<T> type, @Nullable String value) {
        if (value == null) {
            return null;
        }
        return this.getElementByUrl(type, value);
    }

    @Nullable
    public <T> T getElementByHref(@NotNull Class<T> type, @NotNull Category category, @Nullable String value) {
        T element = this.getElementByHref(type, value);
        if (element == null) {
            return null;
        }
        for (Category cat : element.getClass().getAnnotation(ElementCategories.class).value()) {
            if (cat != category) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public Map<String, String> attributes() {
        return this.attributes;
    }

    @NotNull
    public String tagName() {
        return this.tagName;
    }

    @Nullable
    public AttributeNode parent() {
        return this.parent;
    }

    @Nullable
    public String getValue(@NotNull String key) {
        String value = this.attributes.get(key);
        return value != null ? value.trim() : null;
    }

    @NotNull
    public Color getColor(@NotNull String key) {
        String value = this.getValue(key);
        if (value == null) {
            return PaintParser.DEFAULT_COLOR;
        }
        Color c = this.attributeParser.paintParser().parseColor(value.toLowerCase(Locale.ENGLISH), this);
        return c != null ? c : PaintParser.DEFAULT_COLOR;
    }

    @Nullable
    public SVGPaint getPaint(@NotNull String key) {
        String value = this.getValue(key);
        SVGPaint paint = this.getElementByUrl(SVGPaint.class, value);
        if (paint != null) {
            return paint;
        }
        return this.attributeParser.parsePaint(value, this);
    }

    @Nullable
    public Length getLength(@NotNull String key) {
        return this.getLengthInternal(key, null);
    }

    @NotNull
    public Length getLength(@NotNull String key, float fallback) {
        return this.getLength(key, Unit.Raw.valueOf(fallback));
    }

    @NotNull
    public Length getLength(@NotNull String key, @NotNull Length fallback) {
        return this.getLengthInternal(key, fallback);
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    private Length getLengthInternal(@NotNull String key, @Nullable Length fallback) {
        return this.attributeParser.parseLength(this.getValue(key), fallback);
    }

    @NotNull
    public Length getHorizontalReferenceLength(@NotNull String key) {
        return this.parseReferenceLength(key, "left", "right");
    }

    @NotNull
    public Length getVerticalReferenceLength(@NotNull String key) {
        return this.parseReferenceLength(key, "top", "bottom");
    }

    @NotNull
    private Length parseReferenceLength(@NotNull String key, @NotNull String topLeft, @NotNull String bottomRight) {
        String value = this.getValue(key);
        if (topLeft.equals(value)) {
            return TopOrLeft;
        }
        if ("center".equals(value)) {
            return Center;
        }
        if (bottomRight.equals(value)) {
            return BottomOrRight;
        }
        return this.attributeParser.parseLength(value, Length.ZERO);
    }

    public float getPercentage(@NotNull String key, float fallback) {
        return this.attributeParser.parsePercentage(this.getValue(key), fallback);
    }

    @NotNull
    public Length[] getLengthList(@NotNull String key) {
        return this.attributeParser.parseLengthList(this.getValue(key));
    }

    public float[] getFloatList(@NotNull String key) {
        return this.attributeParser.parseFloatList(this.getValue(key));
    }

    public double[] getDoubleList(@NotNull String key) {
        return this.attributeParser.parseDoubleList(this.getValue(key));
    }

    @NotNull
    public <E extends Enum<E>> E getEnum(@NotNull String key, @NotNull E fallback) {
        return this.attributeParser.parseEnum(this.getValue(key), fallback);
    }

    @Nullable
    public <E extends Enum<E>> E getEnumNullable(@NotNull String key, @NotNull Class<E> enumType) {
        return this.attributeParser.parseEnum(this.getValue(key), enumType);
    }

    @Nullable
    public ClipPath getClipPath() {
        return this.getElementByUrl(ClipPath.class, this.getValue("clip-path"));
    }

    @Nullable
    public Mask getMask() {
        return this.getElementByUrl(Mask.class, this.getValue("mask"));
    }

    @Nullable
    public Filter getFilter() {
        return this.getElementByUrl(Filter.class, this.getValue("filter"));
    }

    @Nullable
    public AffineTransform parseTransform(@NotNull String key) {
        return this.attributeParser.parseTransform(this.getValue(key));
    }

    public boolean hasAttribute(@NotNull String name) {
        return this.attributes.containsKey(name);
    }

    @NotNull
    public String[] getStringList(@NotNull String name) {
        return this.getStringList(name, false);
    }

    @NotNull
    public String[] getStringList(@NotNull String name, boolean requireComma) {
        return this.attributeParser.parseStringList(this.getValue(name), requireComma);
    }

    public float getFloat(@NotNull String name, float fallback) {
        return this.attributeParser.parseFloat(this.getValue(name), fallback);
    }

    public int getInt(@NotNull String key, int fallback) {
        return this.attributeParser.parseInt(this.getValue(key), fallback);
    }

    @Nullable
    public String getHref() {
        String href = this.getValue("href");
        if (href == null) {
            return this.getValue("xlink:href");
        }
        return href;
    }

    @Nullable
    public ViewBox getViewBox() {
        float[] viewBoxCords = this.getFloatList("viewBox");
        return viewBoxCords.length == 4 ? new ViewBox(viewBoxCords) : null;
    }

    @NotNull
    public AttributeParser parser() {
        return this.attributeParser;
    }
}

