/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.Circle;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Defs;
import com.github.weisj.jsvg.nodes.Desc;
import com.github.weisj.jsvg.nodes.Ellipse;
import com.github.weisj.jsvg.nodes.Group;
import com.github.weisj.jsvg.nodes.Image;
import com.github.weisj.jsvg.nodes.Line;
import com.github.weisj.jsvg.nodes.LinearGradient;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.Metadata;
import com.github.weisj.jsvg.nodes.Path;
import com.github.weisj.jsvg.nodes.Pattern;
import com.github.weisj.jsvg.nodes.Polygon;
import com.github.weisj.jsvg.nodes.Polyline;
import com.github.weisj.jsvg.nodes.RadialGradient;
import com.github.weisj.jsvg.nodes.Rect;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.SolidColor;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.nodes.Symbol;
import com.github.weisj.jsvg.nodes.Title;
import com.github.weisj.jsvg.nodes.Use;
import com.github.weisj.jsvg.nodes.View;
import com.github.weisj.jsvg.nodes.filter.FeColorMatrix;
import com.github.weisj.jsvg.nodes.filter.FeDisplacementMap;
import com.github.weisj.jsvg.nodes.filter.FeGaussianBlur;
import com.github.weisj.jsvg.nodes.filter.FeTurbulence;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.mesh.MeshGradient;
import com.github.weisj.jsvg.nodes.mesh.MeshPatch;
import com.github.weisj.jsvg.nodes.mesh.MeshRow;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.nodes.text.TextPath;
import com.github.weisj.jsvg.nodes.text.TextSpan;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.DomProcessor;
import com.github.weisj.jsvg.parser.ParsedElement;
import com.github.weisj.jsvg.parser.ParserProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGLoader {
    static final Logger LOGGER = Logger.getLogger(SVGLoader.class.getName());
    @NotNull
    private final Map<String, Supplier<SVGNode>> nodeMap = new HashMap<String, Supplier<SVGNode>>();
    @NotNull
    private final XMLReader xmlReader;

    public SVGLoader() {
        this.nodeMap.put("a", Anchor::new);
        this.nodeMap.put("circle", Circle::new);
        this.nodeMap.put("clippath", ClipPath::new);
        this.nodeMap.put("defs", Defs::new);
        this.nodeMap.put("desc", Desc::new);
        this.nodeMap.put("ellipse", Ellipse::new);
        this.nodeMap.put("fecolormatrix", FeColorMatrix::new);
        this.nodeMap.put("fedisplacementmap", FeDisplacementMap::new);
        this.nodeMap.put("fegaussianblur", FeGaussianBlur::new);
        this.nodeMap.put("feturbulence", FeTurbulence::new);
        this.nodeMap.put("filter", Filter::new);
        this.nodeMap.put("g", Group::new);
        this.nodeMap.put("image", Image::new);
        this.nodeMap.put("line", Line::new);
        this.nodeMap.put("lineargradient", LinearGradient::new);
        this.nodeMap.put("marker", Marker::new);
        this.nodeMap.put("mask", Mask::new);
        this.nodeMap.put("meshgradient", MeshGradient::new);
        this.nodeMap.put("meshpatch", MeshPatch::new);
        this.nodeMap.put("meshrow", MeshRow::new);
        this.nodeMap.put("metadata", Metadata::new);
        this.nodeMap.put("path", Path::new);
        this.nodeMap.put("pattern", Pattern::new);
        this.nodeMap.put("polygon", Polygon::new);
        this.nodeMap.put("polyline", Polyline::new);
        this.nodeMap.put("radialgradient", RadialGradient::new);
        this.nodeMap.put("rect", Rect::new);
        this.nodeMap.put("svg", SVG::new);
        this.nodeMap.put("solidcolor", SolidColor::new);
        this.nodeMap.put("stop", Stop::new);
        this.nodeMap.put("style", Style::new);
        this.nodeMap.put("symbol", Symbol::new);
        this.nodeMap.put("text", Text::new);
        this.nodeMap.put("textpath", TextPath::new);
        this.nodeMap.put("tspan", TextSpan::new);
        this.nodeMap.put("title", Title::new);
        this.nodeMap.put("use", Use::new);
        this.nodeMap.put("view", View::new);
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.xmlReader = saxParser.getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase) {
        return this.load(xmlBase, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase, @NotNull ParserProvider parserProvider) {
        try {
            return this.load(xmlBase.openStream(), parserProvider);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not read " + xmlBase, e);
            return null;
        }
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream) {
        return this.load(inputStream, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider) {
        try {
            this.xmlReader.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0])));
            SVGLoadHandler handler = new SVGLoadHandler(parserProvider);
            this.xmlReader.setContentHandler(handler);
            this.xmlReader.parse(new InputSource(this.createDocumentInputStream(inputStream)));
            return handler.getDocument();
        }
        catch (SAXParseException e) {
            LOGGER.log(Level.WARNING, "Error processing ", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Could not load SVG ", e);
        }
        return null;
    }

    private InputStream createDocumentInputStream(@NotNull InputStream is) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(is);
        bin.mark(2);
        int b0 = bin.read();
        int b1 = bin.read();
        bin.reset();
        if ((b1 << 8 | b0) == 35615) {
            return new GZIPInputStream(bin);
        }
        return bin;
    }

    private class SVGLoadHandler
    extends DefaultHandler {
        private static final boolean DEBUG_PRINT = false;
        private final PrintStream printer = System.out;
        private int nestingLevel = 0;
        private String ident = "";
        private final Map<String, Object> namedElements = new HashMap<String, Object>();
        private final Deque<ParsedElement> currentNodeStack = new ArrayDeque<ParsedElement>();
        private ParsedElement rootNode;
        @NotNull
        private final AttributeParser attributeParser;
        @NotNull
        private final ParserProvider parserProvider;

        private SVGLoadHandler(ParserProvider parserProvider) {
            this.attributeParser = new AttributeParser(parserProvider.createPaintParser());
            this.parserProvider = parserProvider;
        }

        private void setIdent(int level) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append(" ");
            }
            this.ident = builder.toString();
        }

        private boolean isBlank(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Supplier nodeSupplier;
            ParsedElement lastParsedElement;
            ParsedElement parsedElement = lastParsedElement = this.currentNodeStack.isEmpty() ? null : this.currentNodeStack.peek();
            if (lastParsedElement != null) {
                this.flushText(lastParsedElement, true);
            }
            if ((nodeSupplier = (Supplier)SVGLoader.this.nodeMap.get(localName.toLowerCase(Locale.ENGLISH))) != null) {
                SVGNode newNode = (SVGNode)nodeSupplier.get();
                HashMap<String, String> attrs = new HashMap<String, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attrs.put(attributes.getQName(i), attributes.getValue(i));
                }
                ParsedElement parsedElement2 = new ParsedElement(attributes.getValue("id"), new AttributeNode(qName, attrs, lastParsedElement != null ? lastParsedElement.attributeNode() : null, this.namedElements, this.attributeParser), newNode);
                if (lastParsedElement != null) {
                    lastParsedElement.addChild(parsedElement2);
                }
                if (this.rootNode == null) {
                    this.rootNode = parsedElement2;
                }
                this.currentNodeStack.push(parsedElement2);
                String id = parsedElement2.id();
                if (id != null && !this.namedElements.containsKey(id)) {
                    this.namedElements.put(id, parsedElement2.node());
                }
            } else {
                LOGGER.warning("No node registered for tag " + localName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.currentNodeStack.isEmpty() && this.currentNodeStack.peek().attributeNode().tagName().equals(qName)) {
                this.flushText(this.currentNodeStack.pop(), false);
            }
        }

        private void flushText(@NotNull ParsedElement element, boolean segmentBreak) {
            if (element.characterDataParser != null && element.characterDataParser.canFlush(segmentBreak)) {
                element.node().addContent(element.characterDataParser.flush(segmentBreak));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (!this.currentNodeStack.isEmpty() && this.currentNodeStack.peek().characterDataParser != null) {
                this.currentNodeStack.peek().characterDataParser.append(ch, start, length);
            }
        }

        @NotNull
        SVGDocument getDocument() {
            DomProcessor preProcessor = this.parserProvider.createPreProcessor();
            if (preProcessor != null) {
                preProcessor.process(this.rootNode);
            }
            this.rootNode.build();
            DomProcessor postProcessor = this.parserProvider.createPostProcessor();
            if (postProcessor != null) {
                postProcessor.process(this.rootNode);
            }
            return new SVGDocument((SVG)this.rootNode.node());
        }
    }
}

