/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.text.BaselineAlignment;
import com.github.weisj.jsvg.attributes.text.TextAnchor;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class FontRenderContext {
    @Nullable
    private final Length letterSpacing;
    @Nullable
    private final BaselineAlignment baselineAlignment;
    @Nullable
    private final TextAnchor textAnchor;

    public FontRenderContext(@Nullable Length letterSpacing, @Nullable BaselineAlignment baselineAlignment, @Nullable TextAnchor textAnchor) {
        this.letterSpacing = letterSpacing;
        this.baselineAlignment = baselineAlignment;
        this.textAnchor = textAnchor;
    }

    @NotNull
    public Length letterSpacing() {
        return this.letterSpacing != null ? this.letterSpacing : Length.ZERO;
    }

    @NotNull
    public TextAnchor textAnchor() {
        return this.textAnchor != null ? this.textAnchor : TextAnchor.Start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FontRenderContext)) {
            return false;
        }
        FontRenderContext that = (FontRenderContext)o;
        return Objects.equals(this.letterSpacing, that.letterSpacing) && this.baselineAlignment == that.baselineAlignment;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.letterSpacing, this.baselineAlignment});
    }

    @NotNull
    public static FontRenderContext createDefault() {
        return new FontRenderContext(null, null, null);
    }

    @NotNull
    public static FontRenderContext parse(@NotNull AttributeNode attributeNode) {
        return new FontRenderContext(attributeNode.getLength("latter-spacing"), attributeNode.getEnum("baseline-alignment", BaselineAlignment.Auto), attributeNode.getEnumNullable("text-anchor", TextAnchor.class));
    }

    @NotNull
    public FontRenderContext derive(@Nullable FontRenderContext frc) {
        if (frc == null || frc.equals(this)) {
            return this;
        }
        return new FontRenderContext(frc.letterSpacing != null ? frc.letterSpacing : this.letterSpacing, frc.baselineAlignment != null ? frc.baselineAlignment : this.baselineAlignment, frc.textAnchor != null ? frc.textAnchor : this.textAnchor);
    }
}

