/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.MarkerOrientation;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.ShapeNode;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShapeRenderer {
    private static final boolean DEBUG_MARKERS = false;

    private ShapeRenderer() {
    }

    public static void renderShape(@NotNull RenderContext context, @NotNull Graphics2D g, @NotNull Shape shape, @Nullable Rectangle2D bounds, boolean allowFill, boolean allowOutline, float pathLengthFactor) {
        float fOpacity = context.fillOpacity();
        SVGPaint fPaint = context.fillPaint();
        float sOpacity = context.strokeOpacity();
        SVGPaint sPaint = context.strokePaint();
        Stroke stroke = allowOutline ? context.stroke(pathLengthFactor) : null;
        ShapeRenderer.doRenderShape(context, g, shape, bounds, allowFill, allowOutline, fOpacity, fPaint, sOpacity, sPaint, stroke);
    }

    public static void renderShape(@NotNull RenderContext context, @NotNull Graphics2D g, @NotNull Shape shape, @Nullable Rectangle2D bounds, @Nullable Stroke stroke, boolean allowFill, boolean allowOutline) {
        float fOpacity = context.fillOpacity();
        SVGPaint fPaint = context.fillPaint();
        float sOpacity = context.strokeOpacity();
        SVGPaint sPaint = context.strokePaint();
        ShapeRenderer.doRenderShape(context, g, shape, bounds, allowFill, allowOutline, fOpacity, fPaint, sOpacity, sPaint, stroke);
    }

    private static void doRenderShape(@NotNull RenderContext context, @NotNull Graphics2D g, @NotNull Shape shape, @Nullable Rectangle2D bounds, boolean allowFill, boolean allowOutline, float fOpacity, @NotNull SVGPaint fPaint, float sOpacity, @NotNull SVGPaint sPaint, @Nullable Stroke stroke) {
        boolean doOutline;
        boolean doFill = allowFill && fOpacity > 0.0f && fPaint.isVisible();
        boolean bl = doOutline = allowOutline && sOpacity > 0.0f && sPaint.isVisible();
        if (doFill || doOutline) {
            Composite composite = g.getComposite();
            if (doFill) {
                g.setComposite(AlphaComposite.SrcOver.derive(fOpacity));
                fPaint.fillShape(g, context.measureContext(), shape, bounds);
            }
            if (doOutline && stroke != null) {
                g.setComposite(AlphaComposite.SrcOver.derive(sOpacity));
                g.setStroke(stroke);
                sPaint.drawShape(g, context.measureContext(), shape, bounds);
            }
            g.setComposite(composite);
        }
    }

    public static void renderMarkers(@NotNull ShapeNode shapeNode, @NotNull RenderContext context, @NotNull Graphics2D g, @NotNull PathIterator iterator, boolean shouldPaintStartEndMarkersInMiddle, @Nullable Marker start, @Nullable Marker mid, @Nullable Marker end) {
        float[] args = new float[6];
        float x = 0.0f;
        float y = 0.0f;
        float xStart = 0.0f;
        float yStart = 0.0f;
        float dxIn = 0.0f;
        float dyIn = 0.0f;
        float dxOut = 0.0f;
        float dyOut = 0.0f;
        boolean onlyFirst = mid == null && end == null;
        Marker markerToPaint = null;
        MarkerOrientation.MarkerType markerToPaintType = null;
        block7: while (!iterator.isDone()) {
            int type = iterator.currentSegment(args);
            iterator.next();
            Marker nextMarker = iterator.isDone() ? end : mid;
            MarkerOrientation.MarkerType nextMarkerType = iterator.isDone() ? MarkerOrientation.MarkerType.End : MarkerOrientation.MarkerType.Mid;
            float xPaint = x;
            float yPaint = y;
            float dx = dxIn;
            float dy = dyIn;
            switch (type) {
                case 0: {
                    dxOut = 0.0f;
                    dxIn = 0.0f;
                    dyOut = 0.0f;
                    dyIn = 0.0f;
                    x = xStart = args[0];
                    y = yStart = args[1];
                    if (shouldPaintStartEndMarkersInMiddle || markerToPaint == null) {
                        nextMarker = start;
                        nextMarkerType = MarkerOrientation.MarkerType.Start;
                    }
                    if (markerToPaint != null) {
                        ShapeRenderer.paintSingleMarker(shapeNode, context, g, markerToPaintType, markerToPaint, xPaint, yPaint, 0.0f, 0.0f, dx, dy);
                        if (onlyFirst) {
                            return;
                        }
                    }
                    markerToPaint = nextMarker;
                    markerToPaintType = nextMarkerType;
                    continue block7;
                }
                case 1: {
                    dxOut = dxIn = args[0] - x;
                    dyOut = dyIn = args[1] - y;
                    x = args[0];
                    y = args[1];
                    break;
                }
                case 2: {
                    dxOut = args[0] - x;
                    dyOut = args[1] - y;
                    dxIn = args[2] - args[0];
                    dyIn = args[3] - args[1];
                    x = args[2];
                    y = args[3];
                    break;
                }
                case 3: {
                    dxOut = args[0] - x;
                    dyOut = args[1] - y;
                    dxIn = args[4] - args[2];
                    dyIn = args[5] - args[3];
                    x = args[4];
                    y = args[5];
                    break;
                }
                case 4: {
                    dxOut = dxIn = xStart - x;
                    dyOut = dyIn = yStart - y;
                    x = xStart;
                    y = yStart;
                    if (!shouldPaintStartEndMarkersInMiddle) break;
                    nextMarker = end;
                    nextMarkerType = MarkerOrientation.MarkerType.End;
                }
            }
            ShapeRenderer.paintSingleMarker(shapeNode, context, g, markerToPaintType, markerToPaint, xPaint, yPaint, dx, dy, dxOut, dyOut);
            if (onlyFirst) {
                return;
            }
            markerToPaint = nextMarker;
            markerToPaintType = nextMarkerType;
        }
        ShapeRenderer.paintSingleMarker(shapeNode, context, g, markerToPaintType, markerToPaint, x, y, dxIn, dyIn, 0.0f, 0.0f);
    }

    public static void paintSingleMarker(@NotNull ShapeNode shapeNode, @NotNull RenderContext context, @NotNull Graphics2D g, @Nullable MarkerOrientation.MarkerType type, @Nullable Marker marker, float x, float y, float dxIn, float dyIn, float dxOut, float dyOut) {
        if (marker == null) {
            return;
        }
        assert (type != null);
        MarkerOrientation orientation = marker.orientation();
        float rotation = orientation.orientationFor(type, dxIn, dyIn, dxOut, dyOut);
        Graphics2D markerGraphics = (Graphics2D)g.create();
        markerGraphics.translate(x, y);
        markerGraphics.rotate(rotation);
        try (NodeRenderer.Info info = NodeRenderer.createRenderInfo(marker, context, markerGraphics, shapeNode);){
            if (info != null) {
                info.renderable.render(info.context, info.graphics());
            }
        }
        markerGraphics.dispose();
    }

    private static void paintDebugMarker(@NotNull RenderContext context, @NotNull Graphics2D g, @NotNull Marker marker, float rotation) {
        FloatSize size = marker.size(context);
        Path2D.Float p = new Path2D.Float();
        ((Path2D)p).moveTo(0.0, size.height / 2.0f);
        ((Path2D)p).lineTo(size.width, size.height / 2.0f);
        ((Path2D)p).moveTo(0.8 * (double)size.width, 0.35f * size.height);
        ((Path2D)p).lineTo(size.width, size.height / 2.0f);
        ((Path2D)p).lineTo(0.8 * (double)size.width, 0.65f * size.height);
        g.setStroke(new BasicStroke(0.5f));
        g.setColor(Color.MAGENTA.darker().darker());
        g.draw(new Rectangle2D.Float(0.0f, 0.0f, size.width, size.height));
        g.draw(p);
        g.rotate(rotation);
        g.setColor(Color.MAGENTA);
        g.draw(new Rectangle2D.Float(0.0f, 0.0f, size.width, size.height));
        g.draw(p);
    }
}

