/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.geometry.FillRuleAwareAWTSVGShape;
import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import com.github.weisj.jsvg.geometry.path.PathParser;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

public final class PathUtil {
    private PathUtil() {
    }

    @NotNull
    public static MeasurableShape parseFromPathData(@NotNull String data, @NotNull FillRule fillRule) {
        PathCommand[] pathCommands = new PathParser(data).parsePathCommand();
        int nodeCount = 2;
        for (PathCommand pathCommand : pathCommands) {
            nodeCount += pathCommand.getInnerNodes();
        }
        Path2D.Float path = new Path2D.Float(fillRule.awtWindingRule, nodeCount);
        BuildHistory hist = new BuildHistory();
        for (PathCommand pathCommand : pathCommands) {
            pathCommand.appendPath(path, hist);
        }
        return new FillRuleAwareAWTSVGShape(path);
    }
}

