/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class ElementBounds {
    private final Object node;
    private final RenderContext context;
    private Rectangle2D boundingBox;
    private Rectangle2D geometryBox;

    public ElementBounds(Object node, RenderContext context) {
        this.node = node;
        this.context = context;
    }

    @NotNull
    public Rectangle2D boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = ElementBounds.elementBounds(this.node, this.context, HasShape.Box.BoundingBox);
        }
        return this.boundingBox;
    }

    @NotNull
    public Rectangle2D geometryBox() {
        if (this.geometryBox == null) {
            this.geometryBox = ElementBounds.elementBounds(this.node, this.context, HasShape.Box.GeometryBox);
        }
        return this.geometryBox;
    }

    @NotNull
    private static Rectangle2D elementBounds(@NotNull Object node, @NotNull RenderContext context, HasShape.Box box) {
        Rectangle2D elementBounds;
        if (node instanceof HasShape) {
            elementBounds = ((HasShape)node).untransformedElementBounds(context, box);
        } else {
            MeasureContext measureContext = context.measureContext();
            elementBounds = new ViewBox(measureContext.viewWidth(), measureContext.viewHeight());
        }
        return elementBounds;
    }
}

