/*
 * Decompiled with CFR 0.152.
 */
package com.github.wenhao.jpa;

import com.github.wenhao.jpa.specification.AndSpecification;
import com.github.wenhao.jpa.specification.BetweenSpecification;
import com.github.wenhao.jpa.specification.EqualSpecification;
import com.github.wenhao.jpa.specification.GeSpecification;
import com.github.wenhao.jpa.specification.GtSpecification;
import com.github.wenhao.jpa.specification.InSpecification;
import com.github.wenhao.jpa.specification.LeSpecification;
import com.github.wenhao.jpa.specification.LikeSpecification;
import com.github.wenhao.jpa.specification.LtSpecification;
import com.github.wenhao.jpa.specification.NotEqualSpecification;
import com.github.wenhao.jpa.specification.NotInSpecification;
import com.github.wenhao.jpa.specification.NotLikeSpecification;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Range;
import org.springframework.data.jpa.domain.Specification;

public class Specifications<T> {
    private List<Specification<T>> specifications = new ArrayList<Specification<T>>();

    public Specifications<T> eq(String property, Object ... values) {
        return this.eq(true, property, values);
    }

    public Specifications<T> eq(boolean condition, String property, Object ... values) {
        if (condition) {
            this.specifications.add(new EqualSpecification(property, values));
        }
        return this;
    }

    public Specifications<T> ne(String property, Object ... values) {
        return this.ne(true, property, values);
    }

    public Specifications<T> ne(boolean condition, String property, Object ... values) {
        if (condition) {
            this.specifications.add(new NotEqualSpecification(property, values));
        }
        return this;
    }

    public Specifications<T> gt(String property, Number number) {
        return this.gt(true, property, number);
    }

    public Specifications<T> gt(boolean condition, String property, Number number) {
        if (condition) {
            this.specifications.add(new GtSpecification(property, number));
        }
        return this;
    }

    public Specifications<T> ge(String property, Number number) {
        return this.ge(true, property, number);
    }

    public Specifications<T> ge(boolean condition, String property, Number number) {
        if (condition) {
            this.specifications.add(new GeSpecification(property, number));
        }
        return this;
    }

    public Specifications<T> lt(String property, Number number) {
        return this.lt(true, property, number);
    }

    public Specifications<T> lt(boolean condition, String property, Number number) {
        if (condition) {
            this.specifications.add(new LtSpecification(property, number));
        }
        return this;
    }

    public Specifications<T> le(String property, Number number) {
        return this.le(true, property, number);
    }

    public Specifications<T> le(boolean condition, String property, Number number) {
        if (condition) {
            this.specifications.add(new LeSpecification(property, number));
        }
        return this;
    }

    public Specifications<T> between(String property, Range<? extends Comparable<?>> range) {
        return this.between(true, property, range);
    }

    public Specifications<T> between(boolean condition, String property, Range<? extends Comparable<?>> range) {
        if (condition) {
            this.specifications.add(new BetweenSpecification(property, range));
        }
        return this;
    }

    public Specifications<T> like(String property, String ... patterns) {
        return this.like(true, property, patterns);
    }

    public Specifications<T> like(boolean condition, String property, String ... patterns) {
        if (condition) {
            this.specifications.add(new LikeSpecification(property, patterns));
        }
        return this;
    }

    public Specifications<T> notLike(String property, String ... patterns) {
        return this.notLike(true, property, patterns);
    }

    public Specifications<T> notLike(boolean condition, String property, String ... patterns) {
        if (condition) {
            this.specifications.add(new NotLikeSpecification(property, patterns));
        }
        return this;
    }

    public Specifications<T> in(String property, Object ... values) {
        return this.in(true, property, values);
    }

    public Specifications<T> in(boolean condition, String property, Object ... values) {
        if (condition) {
            this.specifications.add(new InSpecification(property, values));
        }
        return this;
    }

    public Specifications<T> notIn(String property, Object ... values) {
        return this.notIn(true, property, values);
    }

    public Specifications<T> notIn(boolean condition, String property, Object ... values) {
        if (condition) {
            this.specifications.add(new NotInSpecification(property, values));
        }
        return this;
    }

    public Specifications<T> and(Specification specification) {
        return this.and(true, specification);
    }

    public Specifications<T> and(boolean condition, Specification specification) {
        if (condition) {
            this.specifications.add(new AndSpecification(specification));
        }
        return this;
    }

    public Specification<T> build() {
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate[] predicates = new Predicate[Specifications.this.specifications.size()];
                for (int i = 0; i < Specifications.this.specifications.size(); ++i) {
                    predicates[i] = ((Specification)Specifications.this.specifications.get(i)).toPredicate(root, query, cb);
                }
                return cb.and(predicates);
            }
        };
    }
}

