/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.ThreadPoolProperties;
import com.github.collector.LogCollector;
import com.github.collector.NothingCollector;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ComponentScan
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class AopLogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AopLogAutoConfiguration.class);
    @Autowired
    private ThreadPoolProperties threadPoolProperties;

    @Bean
    @ConditionalOnMissingBean(value={LogCollector.class})
    public LogCollector nothingCollector() {
        return new NothingCollector();
    }

    @Bean
    @ConditionalOnMissingBean(name={"collectorAsyncExecutor"})
    public Executor collectorAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.threadPoolProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.threadPoolProperties.getMaxPoolSize());
        executor.setQueueCapacity(this.threadPoolProperties.getQueueCapacity());
        executor.setThreadNamePrefix("aop-log-collectorAsyncExecutor-");
        executor.setRejectedExecutionHandler((r, exec) -> log.error("aop-log-collectorAsyncExecutor thread queue is full,activeCount:{},Subsequent collection tasks will be rejected,please check your LogCollector or config your Executor", (Object)exec.getActiveCount()));
        executor.initialize();
        return executor;
    }
}

