/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.MessageFormatter;
import java.util.Date;

public class LogData {
    private static final ThreadLocal<LogData> LOG_DATA = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> CONTENT_BUILDER = new ThreadLocal();
    private String appName;
    private String host;
    private Integer port;
    private String clientIp;
    private String reqUrl;
    private String httpMethod;
    private Object headers;
    private String tag;
    private String content;
    private String method;
    private Object args;
    private Object respBody;
    private Date logDate;
    private long costTime;
    private String threadName = Thread.currentThread().getName();
    private long threadId = Thread.currentThread().getId();
    private boolean success = false;

    private LogData() {
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getReqUrl() {
        return this.reqUrl;
    }

    public void setReqUrl(String reqUrl) {
        this.reqUrl = reqUrl;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Object getHeaders() {
        return this.headers;
    }

    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object getArgs() {
        return this.args;
    }

    public void setArgs(Object args) {
        this.args = args;
    }

    public Object getRespBody() {
        return this.respBody;
    }

    public void setRespBody(Object respBody) {
        this.respBody = respBody;
    }

    public Date getLogDate() {
        return this.logDate == null ? null : (Date)this.logDate.clone();
    }

    public void setLogDate(Date logDate) {
        if (logDate != null) {
            this.logDate = (Date)logDate.clone();
        }
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    protected static LogData getCurrent() {
        if (LOG_DATA.get() == null) {
            LogData logData = new LogData();
            logData.setLogDate(new Date());
            StringBuilder sb = CONTENT_BUILDER.get();
            if (sb == null) {
                CONTENT_BUILDER.set(new StringBuilder());
            }
            LOG_DATA.set(logData);
        }
        return LOG_DATA.get();
    }

    protected static void setCurrent(LogData logData) {
        if (CONTENT_BUILDER.get() != null) {
            logData.setContent(CONTENT_BUILDER.get().toString());
        }
        LOG_DATA.set(logData);
    }

    public static void removeCurrent() {
        CONTENT_BUILDER.remove();
        LOG_DATA.remove();
    }

    public static void step(String step) {
        StringBuilder sb = CONTENT_BUILDER.get();
        if (sb != null) {
            sb.append(step).append("\n");
            CONTENT_BUILDER.set(sb);
        }
    }

    public static void step(String stepTemplate, Object ... args) {
        LogData.step(MessageFormatter.format(stepTemplate, args));
    }
}

