/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.member;

import com.github.jy2.Publisher;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.member.MemberCommand;
import com.github.jy2.di.JyroscopeDi;
import com.github.jy2.di.LogSeldom;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import picocli.CommandLine;

@CommandLine.Command(name="killlocal", description={"Kill all members running on this machine except self"})
public class MemberKilllocalCommand
implements Runnable {
    private static final LogSeldom LOG = JyroscopeDi.getLog();
    @CommandLine.ParentCommand
    MemberCommand parent;

    @Override
    public void run() {
        HashSet<InetAddress> localInterfaces = this.getLocalNetworkInterfaces();
        ArrayList list = Main.introspector.getMemberList();
        for (String member : list) {
            if (member.equals(Main.di.getMemberName()) || !localInterfaces.contains(Main.introspector.getMemberAddress(member))) continue;
            System.out.println("Killing member: " + member);
            Publisher pub = Main.di.createPublisher("/operations" + member.replace('-', '_'), String.class);
            pub.publish((Object)"kill");
        }
    }

    public HashSet<InetAddress> getLocalNetworkInterfaces() {
        HashSet<InetAddress> list = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> ifEnum = NetworkInterface.getNetworkInterfaces();
            while (ifEnum.hasMoreElements()) {
                NetworkInterface netIf = ifEnum.nextElement();
                if (!netIf.isUp()) continue;
                Enumeration<InetAddress> adrEnum = netIf.getInetAddresses();
                while (adrEnum.hasMoreElements()) {
                    list.add(adrEnum.nextElement());
                }
            }
        }
        catch (SocketException e) {
            LOG.error((Object)"Exception caught", (Throwable)e);
        }
        return list;
    }
}

