/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.member;

import com.github.jy2.SlaveClient;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.member.MemberCommand;
import com.github.jy2.commandline.picocli.member.completion.MemberNameCompletionCandidates;
import picocli.CommandLine;

@CommandLine.Command(name="ping", description={"Print XMLRPC reply time from member"})
public class MemberPingCommand
implements Runnable {
    @CommandLine.ParentCommand
    MemberCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the member"}, completionCandidates=MemberNameCompletionCandidates.class)
    String memberName;
    public static boolean runPing = false;

    @Override
    public void run() {
        System.out.println("Pinging member: " + this.memberName);
        System.out.println("Press Crtl-C to stop");
        SlaveClient slaveClient = Main.di.getSlaveClient(this.memberName);
        runPing = true;
        while (runPing) {
            long time = System.nanoTime();
            int pid = slaveClient.getPid();
            double dt = (double)(System.nanoTime() - time) * 1.0E-6;
            System.out.println("xmlrpc reply from " + this.memberName + "\ttime=" + dt + "ms");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

