/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.node;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.node.NodeCommand;
import com.github.jy2.commandline.picocli.node.completion.NodeNameCompletionCandidates;
import java.util.Collection;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Print information about node"})
public class NodeInfoCommand
implements Runnable {
    @CommandLine.ParentCommand
    NodeCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the node"}, completionCandidates=NodeNameCompletionCandidates.class)
    String nodeName;

    @Override
    public void run() {
        if (!Main.introspector.nodeExists(this.nodeName)) {
            System.out.println("Node " + this.nodeName + " does not exist");
            return;
        }
        System.out.println("List of publishers:");
        Collection list = Main.introspector.getPublishersForNode(this.nodeName);
        for (String s : list) {
            System.out.println("\t" + s);
        }
        System.out.println("List of subscribers:");
        list = Main.introspector.getSubscribersForNode(this.nodeName);
        for (String s : list) {
            System.out.println("\t" + s);
        }
    }
}

