/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.param.completion;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import picocli.AutoComplete;
import picocli.CommandLine;

public class ClassNameCompletionCandidates
implements Iterable<String> {
    @Override
    public Iterator<String> iterator() {
        ArrayList<String> list = new ArrayList<String>();
        if (AutoComplete.argIndex != this.getClassNameIndex()) {
            return list.iterator();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)loader).getTopLevelClasses()) {
                list.add(info.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        list.sort(String::compareToIgnoreCase);
        return list.iterator();
    }

    private int getClassNameIndex() {
        if (AutoComplete.tentativeMatch == null) {
            return -1;
        }
        int i = 0;
        for (Object obj : AutoComplete.tentativeMatch) {
            if (!(obj instanceof CommandLine.Model.CommandSpec) && !(obj instanceof CommandLine.Model.OptionSpec) && obj instanceof CommandLine.Model.PositionalParamSpec) {
                CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
                if (pos.index().min == 0) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }
}

