/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.tf.TfCommand;
import com.github.jy2.commandline.picocli.tf.completion.TfChildPositionalCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.completion.TfParentPositionalCompletionCandidates;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="delay", description={"Print delay of the transform with respect to curent time"})
public class TfDelayCommand
implements Runnable {
    @CommandLine.ParentCommand
    TfCommand parent;
    @CommandLine.Parameters(index="0", description={"Parent frame id"}, completionCandidates=TfParentPositionalCompletionCandidates.class)
    String parentFrameId;
    @CommandLine.Parameters(index="1", description={"Child frame id"}, completionCandidates=TfChildPositionalCompletionCandidates.class)
    String childFrameId;

    @Override
    public void run() {
        TopicEchoCommand.subscriber = Main.di.createSubscriber("/tf", TFMessage.class);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<TFMessage>(){

            @Override
            public void accept(TFMessage t) {
                if (TfDelayCommand.this.parentFrameId == null || TfDelayCommand.this.childFrameId == null) {
                    return;
                }
                try {
                    for (TransformStamped tr : t.transforms) {
                        if (TfDelayCommand.this.parentFrameId != null && !tr.header.frameId.equals(TfDelayCommand.this.parentFrameId) || TfDelayCommand.this.childFrameId != null && !tr.childFrameId.equals(TfDelayCommand.this.childFrameId)) continue;
                        double nowSeconds = (double)System.currentTimeMillis() * 0.001;
                        double deltaMillis = (nowSeconds - tr.header.toSeconds()) * 1000.0;
                        System.out.printf("\t%.3fms\n", deltaMillis);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

