/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.tf.TfCommand;
import com.github.jy2.commandline.picocli.tf.completion.TfChildOptionCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.completion.TfParentOptionCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.format.TfDisplayFormat;
import com.github.jy2.commandline.picocli.tf.format.TfSerializer;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="echo", description={"Print transform on screen"})
public class TfEchoCommand
implements Runnable {
    @CommandLine.ParentCommand
    TfCommand parent;
    @CommandLine.Option(names={"--parent"}, description={"Parent frame id"}, completionCandidates=TfParentOptionCompletionCandidates.class)
    String parentFrameId;
    @CommandLine.Option(names={"--child"}, description={"Child frame id"}, completionCandidates=TfChildOptionCompletionCandidates.class)
    String childFrameId;
    @CommandLine.Option(names={"--grep"}, description={"Character sequence to be expected in parent frame id or child frame id"})
    String grep;
    @CommandLine.Option(names={"--format"}, description={"Format to display the transform"})
    TfDisplayFormat format = TfDisplayFormat.rpy;

    @Override
    public void run() {
        System.out.println("Subscribed to topic: /tf");
        System.out.println("Press Crtl-C to stop");
        TopicEchoCommand.subscriber = Main.di.createSubscriber("/tf", TFMessage.class);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<TFMessage>(){

            @Override
            public void accept(TFMessage t) {
                try {
                    for (TransformStamped tr : t.transforms) {
                        if (TfEchoCommand.this.parentFrameId != null && !tr.header.frameId.equals(TfEchoCommand.this.parentFrameId) || TfEchoCommand.this.childFrameId != null && !tr.childFrameId.equals(TfEchoCommand.this.childFrameId) || TfEchoCommand.this.grep != null && !tr.header.frameId.contains(TfEchoCommand.this.grep) && !tr.childFrameId.contains(TfEchoCommand.this.grep)) continue;
                        System.out.println("\t" + TfSerializer.serialize(tr, TfEchoCommand.this.format));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

