/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.tf.TfCommand;
import com.github.jy2.commandline.picocli.tf.completion.TfChildPositionalCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.completion.TfParentPositionalCompletionCandidates;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="hz", description={"Print delay of the transform with respect to curent time"})
public class TfHzCommand
implements Runnable {
    @CommandLine.ParentCommand
    TfCommand parent;
    @CommandLine.Parameters(index="0", description={"Parent frame id"}, completionCandidates=TfParentPositionalCompletionCandidates.class)
    String parentFrameId;
    @CommandLine.Parameters(index="1", description={"Child frame id"}, completionCandidates=TfChildPositionalCompletionCandidates.class)
    String childFrameId;
    @CommandLine.Option(names={"--period"}, description={"Measurement period in seconds"})
    double periodSeconds = 1.0;

    @Override
    public void run() {
        System.out.printf("Subscribed to %s->%s, minimal measurement period: %.3fs\n", this.parentFrameId, this.childFrameId, this.periodSeconds);
        System.out.println("Press Crtl-C to stop");
        TopicEchoCommand.subscriber = Main.di.createSubscriber("/tf", TFMessage.class);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<TFMessage>(){
            private volatile int counter = 0;
            private volatile double startTime = -1.0;
            private volatile double prevTime = -1.0;
            private volatile double minPeriod = Double.MAX_VALUE;
            private volatile double maxPeriod = Double.MIN_VALUE;

            @Override
            public synchronized void accept(TFMessage t) {
                try {
                    if (TfHzCommand.this.parentFrameId == null || TfHzCommand.this.childFrameId == null) {
                        return;
                    }
                    for (TransformStamped tr : t.transforms) {
                        if (!tr.header.frameId.equals(TfHzCommand.this.parentFrameId) || !tr.childFrameId.equals(TfHzCommand.this.childFrameId)) continue;
                        double time = (double)System.nanoTime() * 1.0E-9;
                        ++this.counter;
                        if (this.startTime == -1.0) {
                            this.prevTime = this.startTime = time;
                            this.counter = 0;
                        }
                        double delta = time - this.startTime;
                        double period = time - this.prevTime;
                        this.prevTime = time;
                        if (this.minPeriod > period && this.counter > 0) {
                            this.minPeriod = period;
                        }
                        if (this.maxPeriod < period && this.counter > 0) {
                            this.maxPeriod = period;
                        }
                        if (this.counter <= 0 || !(delta > TfHzCommand.this.periodSeconds)) continue;
                        double frequency = (double)this.counter / delta;
                        double invFrequency = 1000.0 * delta / (double)this.counter;
                        System.err.printf("\tRate: %.3fHz Period: %.3fms Min: %.3fms Max: %.3fms Count: %d\n", frequency, invFrequency, this.minPeriod * 1000.0, this.maxPeriod * 1000.0, this.counter);
                        this.counter = 0;
                        this.startTime = time;
                        this.minPeriod = Double.MAX_VALUE;
                        this.maxPeriod = Double.MIN_VALUE;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

