/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf.format;

import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class QuaternionUtils {
    public static Quat4d eulerToQuaternion(Vector3d rotation, Quat4d q) {
        double eulerX = rotation.x;
        double eulerY = rotation.y;
        double eulerZ = rotation.z;
        double sx = Math.sin(eulerX / 2.0);
        double sy = Math.sin(eulerY / 2.0);
        double sz = Math.sin(eulerZ / 2.0);
        double cx = Math.cos(eulerX / 2.0);
        double cy = Math.cos(eulerY / 2.0);
        double cz = Math.cos(eulerZ / 2.0);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double d = cycz * cx - sysz * sx;
        double a = cycz * sx + sysz * cx;
        double b = sy * cz * cx + cy * sz * sx;
        double c = cy * sz * cx - sy * cz * sx;
        q.x = a;
        q.y = b;
        q.z = c;
        q.w = d;
        q.normalize();
        return q;
    }

    public static Vector3d quaternionToEuler(Quat4d q, Vector3d v) {
        double bank;
        double sqw = q.w * q.w;
        double sqx = q.x * q.x;
        double sqy = q.y * q.y;
        double sqz = q.z * q.z;
        double unit = sqx + sqy + sqz + sqw;
        double test = q.x * q.y + q.z * q.w;
        double heading = Math.atan2(2.0 * q.y * q.w - 2.0 * q.x * q.z, sqx - sqy - sqz + sqw);
        double attitude = test > 0.4999999999 * unit ? 1.5707963267948966 : (test < -0.4999999999 * unit ? -1.5707963267948966 : Math.asin(2.0 * test / unit));
        v.x = bank = Math.atan2(2.0 * q.x * q.w - 2.0 * q.y * q.z, -sqx + sqy - sqz + sqw);
        v.y = heading;
        v.z = attitude;
        return v;
    }

    public static Quat4d rpyToQuaternion(Vector3d rotation, Quat4d q) {
        double halfYaw = rotation.z * 0.5;
        double halfPitch = rotation.y * 0.5;
        double halfRoll = rotation.x * 0.5;
        double cosYaw = Math.cos(halfYaw);
        double sinYaw = Math.sin(halfYaw);
        double cosPitch = Math.cos(halfPitch);
        double sinPitch = Math.sin(halfPitch);
        double cosRoll = Math.cos(halfRoll);
        double sinRoll = Math.sin(halfRoll);
        q.x = sinRoll * cosPitch * cosYaw - cosRoll * sinPitch * sinYaw;
        q.y = cosRoll * sinPitch * cosYaw + sinRoll * cosPitch * sinYaw;
        q.z = cosRoll * cosPitch * sinYaw - sinRoll * sinPitch * cosYaw;
        q.w = cosRoll * cosPitch * cosYaw + sinRoll * sinPitch * sinYaw;
        q.normalize();
        return q;
    }

    public static Vector3d quaternionToRpy(Quat4d q, Vector3d v) {
        double sqw = q.w * q.w;
        double sqx = q.x * q.x;
        double sqy = q.y * q.y;
        double sqz = q.z * q.z;
        double unit = sqx + sqy + sqz + sqw;
        double test = q.w * q.y - q.z * q.x;
        double heading = Math.atan2(2.0 * q.w * q.x + 2.0 * q.y * q.z, 1.0 - 2.0 * sqx - 2.0 * sqy);
        double attitude = test > 0.4999999999 * unit ? 1.5707963267948966 : (test < -0.4999999999 * unit ? -1.5707963267948966 : Math.asin(2.0 * test / unit));
        double bank = Math.atan2(2.0 * q.w * q.z + 2.0 * q.x * q.y, 1.0 - 2.0 * sqy - 2.0 * sqz);
        v.x = heading;
        v.y = attitude;
        v.z = bank;
        return v;
    }

    public static Quat4d eulerToQuaternion2(Vector3d rotation, Quat4d q) {
        double halfYaw = rotation.z * 0.5;
        double halfPitch = rotation.y * 0.5;
        double halfRoll = rotation.x * 0.5;
        double cosYaw = Math.cos(halfYaw);
        double sinYaw = Math.sin(halfYaw);
        double cosPitch = Math.cos(halfPitch);
        double sinPitch = Math.sin(halfPitch);
        double cosRoll = Math.cos(halfRoll);
        double sinRoll = Math.sin(halfRoll);
        q.x = sinRoll * cosPitch * cosYaw + cosRoll * sinPitch * sinYaw;
        q.y = cosRoll * sinPitch * cosYaw + sinRoll * cosPitch * sinYaw;
        q.z = cosRoll * cosPitch * sinYaw - sinRoll * sinPitch * cosYaw;
        q.w = cosRoll * cosPitch * cosYaw - sinRoll * sinPitch * sinYaw;
        q.normalize();
        return q;
    }
}

