/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf.format;

import com.github.jy2.commandline.picocli.tf.format.QuaternionUtils;
import com.github.jy2.commandline.picocli.tf.format.TfDisplayFormat;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import javax.vecmath.Vector3d;

public class TfSerializer {
    public static String serialize(TransformStamped t, TfDisplayFormat format) {
        if (format.equals((Object)TfDisplayFormat.mat)) {
            return "time: " + t.header.toSeconds() + " " + TfSerializer.typeToString(t) + t.header.frameId + "->" + t.childFrameId + "\n" + t.asMatrix().toString();
        }
        if (format.equals((Object)TfDisplayFormat.quat)) {
            return String.format("time: %.3f %s%s->%s\n\t\ttranslation: [%.3f,%.3f,%.3f] quaternion: [%.3f,%.3f,%.3f,%.3f]", t.header.toSeconds(), TfSerializer.typeToString(t), t.header.frameId, t.childFrameId, t.transform.translation.x, t.transform.translation.y, t.transform.translation.z, t.transform.rotation.x, t.transform.rotation.y, t.transform.rotation.z, t.transform.rotation.w);
        }
        Vector3d v = QuaternionUtils.quaternionToRpy(t.transform.rotation.asQuat4d(), new Vector3d());
        return String.format("time: %.3f %s%s->%s\n\t\ttranslation: [%.3f,%.3f,%.3f] rotation: [%.3f,%.3f,%.3f]", t.header.toSeconds(), TfSerializer.typeToString(t), t.header.frameId, t.childFrameId, t.transform.translation.x, t.transform.translation.y, t.transform.translation.z, v.z, v.y, v.x);
    }

    private static String typeToString(TransformStamped t) {
        if (t.childFrameId.contains("static")) {
            return "static ";
        }
        if (t.childFrameId.contains("semi")) {
            return "semi ";
        }
        return "";
    }
}

