/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="hz", description={"Print publishing rate of topics"})
public class TopicHzCommand
implements Runnable {
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;
    @CommandLine.Option(names={"--period"}, description={"Measurement period in seconds"})
    double periodSeconds = 1.0;

    @Override
    public void run() {
        System.out.printf("Subscribed to topic: %s, minimal measurement period: %.3f s\n", this.topicName, this.periodSeconds);
        System.out.println("Press Crtl-C to stop");
        Class type = Main.introspector.getTopicType(this.topicName);
        TopicEchoCommand.subscriber = Main.di.createSubscriber(this.topicName, type, 5, 50);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<Object>(){
            private volatile int counter = 0;
            private volatile double startTime = -1.0;
            private volatile double prevTime = -1.0;
            private volatile double minPeriod = Double.MAX_VALUE;
            private volatile double maxPeriod = Double.MIN_VALUE;

            @Override
            public synchronized void accept(Object t) {
                try {
                    double time = (double)System.nanoTime() * 1.0E-9;
                    ++this.counter;
                    if (this.startTime == -1.0) {
                        this.prevTime = this.startTime = time;
                        this.counter = 0;
                    }
                    double delta = time - this.startTime;
                    double period = time - this.prevTime;
                    this.prevTime = time;
                    if (this.minPeriod > period && this.counter > 0) {
                        this.minPeriod = period;
                    }
                    if (this.maxPeriod < period && this.counter > 0) {
                        this.maxPeriod = period;
                    }
                    if (this.counter > 0 && delta > TopicHzCommand.this.periodSeconds) {
                        double frequency = (double)this.counter / delta;
                        double invFrequency = 1000.0 * delta / (double)this.counter;
                        System.err.printf("\tRate: %.3fHz Period: %.3fms Min: %.3fms Max: %.3fms Count: %d\n", frequency, invFrequency, this.minPeriod * 1000.0, this.maxPeriod * 1000.0, this.counter);
                        this.counter = 0;
                        this.startTime = time;
                        this.minPeriod = Double.MAX_VALUE;
                        this.maxPeriod = Double.MIN_VALUE;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

