/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.Publisher;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicMessageCompletionCandidates;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import com.github.jy2.commandline.picocli.topic.completion.TopicTypeCompletionCandidates;
import picocli.CommandLine;

@CommandLine.Command(name="pub", description={"Publish message to topic"})
public class TopicPubCommand
implements Runnable {
    public static PublisherThread thread = null;
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;
    @CommandLine.Parameters(index="1", description={"Type of the topic"}, completionCandidates=TopicTypeCompletionCandidates.class)
    String topicType;
    @CommandLine.Parameters(index="2", description={"Message to be sent"}, completionCandidates=TopicMessageCompletionCandidates.class)
    String message;
    @CommandLine.Option(names={"--latched"}, description={"Whether to set publisher in latched mode"})
    boolean latched;
    @CommandLine.Option(names={"--rate"}, description={"Rate in Hz to keep sending the messages"})
    Double rate = null;

    @Override
    public void run() {
        Class<?> type;
        System.out.println("Publishing to topic: " + this.topicName + ", message: " + this.message);
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            type = classLoader != null ? Class.forName(this.topicType, false, classLoader) : Class.forName(this.topicType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Publisher publisher = Main.di.createPublisher(this.topicName, type, this.latched);
        if (this.rate == null) {
            publisher.publish(Main.deserializer.deserialize(type, this.message));
        } else {
            System.out.println("Press Crtl-C to stop");
            thread = new PublisherThread(publisher, Main.deserializer.deserialize(type, this.message));
            thread.start();
        }
    }

    public final class PublisherThread
    extends Thread {
        private final Publisher<Object> publisher;
        private final Object obj;
        public boolean stop = false;

        private PublisherThread(Publisher<Object> publisher, Object obj) {
            this.publisher = publisher;
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    this.publisher.publish(this.obj);
                    PublisherThread publisherThread = this;
                    synchronized (publisherThread) {
                        this.wait((long)(1000.0 / TopicPubCommand.this.rate));
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

