/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic.completion;

import com.github.jy2.commandline.picocli.Main;
import java.util.ArrayList;
import java.util.Iterator;
import picocli.AutoComplete;
import picocli.CommandLine;

public class TopicMessageCompletionCandidates
implements Iterable<String> {
    @Override
    public Iterator<String> iterator() {
        if (AutoComplete.argIndex != this.getTopicMessageIndex()) {
            return new ArrayList().iterator();
        }
        ArrayList<String> list = new ArrayList<String>();
        String topicType = this.getTopicType();
        if (topicType != null && !topicType.isEmpty()) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = classLoader != null ? Class.forName(topicType, false, classLoader) : Class.forName(topicType);
                Object obj = clazz.newInstance();
                list.add("'" + Main.serializer.serialize(obj) + "'");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        list.sort(String::compareToIgnoreCase);
        return list.iterator();
    }

    private int getTopicMessageIndex() {
        if (AutoComplete.tentativeMatch == null) {
            return -1;
        }
        int i = 0;
        for (Object obj : AutoComplete.tentativeMatch) {
            if (!(obj instanceof CommandLine.Model.CommandSpec) && !(obj instanceof CommandLine.Model.OptionSpec) && obj instanceof CommandLine.Model.PositionalParamSpec) {
                CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
                if (pos.index().min == 2) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private String getTopicType() {
        if (AutoComplete.tentativeMatch == null) {
            return null;
        }
        for (Object obj : AutoComplete.tentativeMatch) {
            if (obj instanceof CommandLine.Model.CommandSpec || obj instanceof CommandLine.Model.OptionSpec || !(obj instanceof CommandLine.Model.PositionalParamSpec)) continue;
            CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
            if (pos.index().min != 1) continue;
            String value = pos.stringValues().get(0);
            return value;
        }
        return null;
    }
}

