/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.logs.console.model;

import com.github.jy2.logs.console.model.Place;
import com.github.jy2.logs.console.utils.LogLevel;
import com.github.jy2.logs.console.utils.LogLevelUtils;
import go.jyroscope.ros.rosgraph_msgs.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Level
implements Comparable<Level> {
    public LogLevel level;
    public ArrayList<Place> placeList = new ArrayList();
    public HashMap<String, Place> placeMap = new HashMap();

    public void add(Log log) {
        Place place = this.getOrCreate(log.file, log.line);
        place.add(log);
    }

    public int getNumPlaces() {
        return this.placeList.size();
    }

    public synchronized Place getPlace(int i) {
        if (i >= this.placeList.size()) {
            return null;
        }
        return this.placeList.get(i);
    }

    private synchronized Place getOrCreate(String file, int line) {
        String hash = file + ":" + line;
        Place o = this.placeMap.get(hash);
        if (o == null) {
            o = new Place();
            o.file = file;
            o.line = line;
            this.placeMap.put(hash, o);
            this.placeList.add(o);
            Collections.sort(this.placeList);
        }
        return o;
    }

    @Override
    public int compareTo(Level o) {
        return LogLevelUtils.toRosLevel(o.level) - LogLevelUtils.toRosLevel(this.level);
    }

    public String toString() {
        return this.level.toString();
    }
}

