/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.logs.console.model;

import com.github.jy2.logs.console.model.Level;
import com.github.jy2.logs.console.utils.LogLevel;
import com.github.jy2.logs.console.utils.LogLevelUtils;
import com.github.jy2.logs.console.utils.LogStringUtils;
import go.jyroscope.ros.rosgraph_msgs.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Node
implements Comparable<Node> {
    public String name;
    public ArrayList<Level> levelList = new ArrayList();
    public HashMap<LogLevel, Level> levelMap = new HashMap();

    public void add(Log log) {
        Level level = this.getOrCreate(LogLevelUtils.fromRosLevel(log.level));
        level.add(log);
    }

    public int getNumLevels() {
        return this.levelList.size();
    }

    public synchronized Level getLevel(int i) {
        if (i >= this.levelList.size()) {
            return null;
        }
        return this.levelList.get(i);
    }

    @Override
    public int compareTo(Node o) {
        return LogStringUtils.nullSafeStringComparator(this.name, o.name);
    }

    private synchronized Level getOrCreate(LogLevel level) {
        Level o = this.levelMap.get((Object)level);
        if (o == null) {
            o = new Level();
            o.level = level;
            this.levelMap.put(level, o);
            this.levelList.add(o);
            Collections.sort(this.levelList);
        }
        return o;
    }
}

