/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.log;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.log.LogCommand;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import com.github.jy2.logs.console.utils.LogLevel;
import com.github.jy2.logs.console.utils.LogLevelUtils;
import go.jyroscope.ros.rosgraph_msgs.Log;
import java.text.SimpleDateFormat;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="echo", description={"Print list of topics"})
public class LogEchoCommand
implements Runnable {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    @CommandLine.ParentCommand
    LogCommand parent;
    @CommandLine.Option(names={"--level"}, description={"Logging level"})
    LogLevel level;
    @CommandLine.Option(names={"--node"}, description={"Node name"})
    String node;
    @CommandLine.Option(names={"--class"}, description={"Class name"})
    String file;
    @CommandLine.Option(names={"--method"}, description={"Method name"})
    String function;
    @CommandLine.Option(names={"--line"}, description={"Line number"})
    int line = -1;
    @CommandLine.Option(names={"--grep"}, description={"Character sequence to be expected in serialized message content"})
    String grep;
    @CommandLine.Option(names={"--fullMessage"}, description={"Display full message"})
    boolean fullMessage = false;

    @Override
    public void run() {
        System.out.println("Subscribed to topic: /rosout");
        System.out.println("Press Crtl-C to stop");
        TopicEchoCommand.subscriber = Main.di.createSubscriber("/rosout", null);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<Object>(){
            private volatile int counter = 0;

            @Override
            public void accept(Object t) {
                try {
                    byte minLevel;
                    Log log = (Log)t;
                    if (LogEchoCommand.this.level != null && log.level < (minLevel = LogLevelUtils.toRosLevel(LogEchoCommand.this.level))) {
                        return;
                    }
                    if (LogEchoCommand.this.node != null && !LogEchoCommand.this.node.equals(log.name)) {
                        return;
                    }
                    if (LogEchoCommand.this.file != null && !LogEchoCommand.this.file.equals(log.file)) {
                        return;
                    }
                    if (LogEchoCommand.this.function != null && !LogEchoCommand.this.function.equals(log.function)) {
                        return;
                    }
                    if (LogEchoCommand.this.line >= 0 && LogEchoCommand.this.line != log.line) {
                        return;
                    }
                    String s = Main.serializer.serialize(log);
                    if (LogEchoCommand.this.grep != null && !s.contains(LogEchoCommand.this.grep)) {
                        return;
                    }
                    String strNode = log.name;
                    String strLevel = LogLevelUtils.fromRosLevel(log.level).toString();
                    String strPlace = log.file + ":" + log.line;
                    String strMethod = log.function;
                    String strMsg = log.msg;
                    System.out.printf("%s %s %.3f %s %s\n%s\n", strLevel, strNode, log.header.toSeconds(), strPlace, strMethod, strMsg);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

