/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.param;

import com.github.jy2.commandline.picocli.param.ParamCommand;
import com.github.jy2.commandline.picocli.param.completion.ClassNameCompletionCandidates;
import com.github.jy2.di.utils.JsonMapper;
import picocli.CommandLine;

@CommandLine.Command(name="showJson", description={"Show json representation of a class"})
public class ParamShowJsonCommand
implements Runnable {
    @CommandLine.ParentCommand
    ParamCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the class"}, completionCandidates=ClassNameCompletionCandidates.class)
    String className;

    @Override
    public void run() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader != null ? Class.forName(this.className, false, classLoader) : Class.forName(this.className);
            Object o = clazz.newInstance();
            String json = JsonMapper.mapWithRuntimeException(o);
            System.out.println(json);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }
}

