/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf.completion;

import com.github.jy2.Subscriber;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.tf.mat.TfManager;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import picocli.AutoComplete;
import picocli.CommandLine;

public class TfParentPositionalCompletionCandidates
implements Iterable<String> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> iterator() {
        ArrayList<String> list = new ArrayList<String>();
        if (AutoComplete.argIndex != this.getTfParentIndex()) {
            return list.iterator();
        }
        Subscriber subscriber = null;
        try {
            subscriber = Main.di.createSubscriber("/tf", TFMessage.class);
            final TfManager tfManager = new TfManager();
            subscriber.addMessageListener((Consumer)new Consumer<TFMessage>(){

                @Override
                public void accept(TFMessage t) {
                    try {
                        tfManager.add(t);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            subscriber.removeAllMessageListeners();
            ArrayList tfList = tfManager.getTransformList();
            for (TransformStamped t : tfList) {
                list.add(t.header.frameId);
            }
        }
        finally {
            if (subscriber != null) {
                subscriber.removeAllMessageListeners();
            }
        }
        return list.iterator();
    }

    private int getTfParentIndex() {
        if (AutoComplete.tentativeMatch == null) {
            return -1;
        }
        int i = 0;
        for (Object obj : AutoComplete.tentativeMatch) {
            if (!(obj instanceof CommandLine.Model.CommandSpec) && !(obj instanceof CommandLine.Model.OptionSpec) && obj instanceof CommandLine.Model.PositionalParamSpec) {
                CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
                if (pos.index().min == 0) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }
}

