/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.Subscriber;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import com.github.jy2.introspection.TopicInfo;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="echo", description={"Print list of topics"})
public class TopicEchoCommand
implements Runnable {
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;
    @CommandLine.Option(names={"--grep"}, description={"Character sequence to be expected in serialized message content"})
    String grep;
    public static Subscriber subscriber = null;

    @Override
    public void run() {
        System.out.println("Subscribed to topic: " + this.topicName);
        System.out.println("Press Crtl-C to stop");
        Class<?> type = Main.introspector.getTopicType(this.topicName);
        TopicInfo ti = Main.introspector.getTopicInfo(this.topicName);
        if (ti.reportedJavaType != null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                type = classLoader != null ? Class.forName(ti.reportedJavaType, false, classLoader) : Class.forName(ti.reportedJavaType);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        subscriber = Main.di.createSubscriber(this.topicName, (Class)type, 5, 50);
        subscriber.addMessageListener((Consumer)new Consumer<Object>(){
            private volatile int counter = 0;

            @Override
            public void accept(Object t) {
                try {
                    String s = Main.serializer.serialize(t);
                    if (TopicEchoCommand.this.grep != null && !s.contains(TopicEchoCommand.this.grep)) {
                        return;
                    }
                    System.out.println("" + this.counter++ + "\t" + t.getClass().getCanonicalName() + " '" + s + "'");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

