/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import com.github.jy2.introspection.TopicInfo;
import java.util.Collection;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Print information about topic"})
public class TopicInfoCommand
implements Runnable {
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;

    @Override
    public void run() {
        Class type = Main.introspector.getTopicType(this.topicName);
        String typeName = type == null ? "null" : type.getName();
        System.out.println("Master type: " + typeName);
        TopicInfo ti = Main.introspector.getTopicInfo(this.topicName);
        System.out.println("Remote type: " + ti.reportedRosType);
        System.out.println("Remote java type: " + ti.reportedJavaType);
        System.out.println("Remote is latched: " + ti.reportedIsLatched);
        System.out.println("List of publishing nodes:");
        Collection list = Main.introspector.getNodesPublishingTopic(this.topicName);
        for (String s : list) {
            System.out.println("\t" + s);
        }
        System.out.println("List of subscribed nodes:");
        list = Main.introspector.getNodesSubscribedToTopic(this.topicName);
        for (String s : list) {
            System.out.println("\t" + s);
        }
    }
}

