/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import java.util.ArrayList;
import java.util.HashSet;
import picocli.CommandLine;

@CommandLine.Command(name="who", description={"List of members who publish to the topic"})
public class TopicWhoCommand
implements Runnable {
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;
    @CommandLine.Option(names={"--waitTime"}, description={"Define how long to wait for transforms in seconds"})
    double waitTime = 2.0;

    @Override
    public void run() {
        System.out.println("Pausing for " + this.waitTime + " second(s) to collect publishers to topic");
        HashSet set = Main.introspector.getPublishingMembers(this.topicName, (long)(this.waitTime * 1000.0), null);
        for (String m : set) {
            System.out.println("\t" + m);
            ArrayList list2 = Main.introspector.getMemberNodeList(m);
            list2.sort(String::compareToIgnoreCase);
            for (String s2 : list2) {
                System.out.println("\t\t" + s2);
            }
        }
    }
}

