/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic.completion;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.introspection.TopicInfo;
import java.util.ArrayList;
import java.util.Iterator;
import picocli.AutoComplete;
import picocli.CommandLine;

public class TopicTypeCompletionCandidates
implements Iterable<String> {
    public static String topicName;

    @Override
    public Iterator<String> iterator() {
        if (AutoComplete.argIndex != this.getTopicTypeIndex()) {
            return new ArrayList().iterator();
        }
        ArrayList<String> list = new ArrayList<String>();
        String topicName = this.getTopicName();
        if (topicName != null) {
            Class<?> type = Main.introspector.getTopicType(topicName);
            TopicInfo ti = Main.introspector.getTopicInfo(topicName);
            if (ti.reportedJavaType != null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    type = classLoader != null ? Class.forName(ti.reportedJavaType, false, classLoader) : Class.forName(ti.reportedJavaType);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (type != null) {
                list.add(type.getCanonicalName());
            }
        }
        return list.iterator();
    }

    private int getTopicTypeIndex() {
        if (AutoComplete.tentativeMatch == null) {
            return -1;
        }
        int i = 0;
        for (Object obj : AutoComplete.tentativeMatch) {
            if (!(obj instanceof CommandLine.Model.CommandSpec) && !(obj instanceof CommandLine.Model.OptionSpec) && obj instanceof CommandLine.Model.PositionalParamSpec) {
                CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
                if (pos.index().min == 1) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private String getTopicName() {
        if (AutoComplete.tentativeMatch == null) {
            return null;
        }
        for (Object obj : AutoComplete.tentativeMatch) {
            if (obj instanceof CommandLine.Model.CommandSpec || obj instanceof CommandLine.Model.OptionSpec || !(obj instanceof CommandLine.Model.PositionalParamSpec)) continue;
            CommandLine.Model.PositionalParamSpec pos = (CommandLine.Model.PositionalParamSpec)obj;
            if (pos.index().min != 0) continue;
            String value = pos.stringValues().get(0);
            return value;
        }
        return null;
    }
}

