/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public class Deserializer {
    private static ObjectMapper mapper = new ObjectMapper();

    public Deserializer() {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public Object deserialize(Class<?> type, String string) {
        if (type.equals(Boolean.class)) {
            return Boolean.parseBoolean(string);
        }
        if (type.equals(Character.class)) {
            return Character.valueOf(string.charAt(0));
        }
        if (type.equals(Byte.class)) {
            return (byte)Integer.parseInt(string);
        }
        if (type.equals(Short.class)) {
            return (short)Integer.parseInt(string);
        }
        if (type.equals(Integer.class)) {
            return (int)Long.parseLong(string);
        }
        if (type.equals(Long.class)) {
            return Long.parseLong(string);
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (type.equals(Double.class)) {
            return Double.parseDouble(string);
        }
        if (type.equals(String.class)) {
            return string;
        }
        if (type.equals(Void.class)) {
            return "";
        }
        return Deserializer.mapWithRuntimeException(string, type);
    }

    public static <T> T mapWithRuntimeException(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem with parsing " + clazz.getCanonicalName() + ": " + json, e);
        }
    }
}

